/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.validation;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.validation.DecisionTableValidator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DecisionTableValidatorHitPolicyAttributeLimitationsTest {
    private final GuidedDecisionTable52.HitPolicy hitPolicy;
    private final String attribute;
    private final boolean isAllowed;

    public DecisionTableValidatorHitPolicyAttributeLimitationsTest(GuidedDecisionTable52.HitPolicy hitPolicy, String attribute, boolean isAllowed) {
        this.hitPolicy = hitPolicy;
        this.attribute = attribute;
        this.isAllowed = isAllowed;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> attributes() {
        return Arrays.asList({GuidedDecisionTable52.HitPolicy.NONE, Attribute.SALIENCE.getAttributeName(), true}, {GuidedDecisionTable52.HitPolicy.FIRST_HIT, Attribute.SALIENCE.getAttributeName(), false}, {GuidedDecisionTable52.HitPolicy.RULE_ORDER, Attribute.SALIENCE.getAttributeName(), false}, {GuidedDecisionTable52.HitPolicy.UNIQUE_HIT, Attribute.SALIENCE.getAttributeName(), true}, {GuidedDecisionTable52.HitPolicy.NONE, Attribute.ACTIVATION_GROUP.getAttributeName(), true}, {GuidedDecisionTable52.HitPolicy.FIRST_HIT, Attribute.ACTIVATION_GROUP.getAttributeName(), false}, {GuidedDecisionTable52.HitPolicy.RULE_ORDER, Attribute.ACTIVATION_GROUP.getAttributeName(), true}, {GuidedDecisionTable52.HitPolicy.UNIQUE_HIT, Attribute.ACTIVATION_GROUP.getAttributeName(), false});
    }

    @Test
    public void addAttributeColumn() throws Exception {
        GuidedDecisionTable52 table = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)table.getHitPolicy()).thenReturn((Object)this.hitPolicy);
        DecisionTableValidator validator = new DecisionTableValidator(table);
        AttributeCol52 attributeCol52 = new AttributeCol52();
        attributeCol52.setAttribute(this.attribute);
        boolean wasAllowed = true;
        try {
            validator.isValidToAdd(attributeCol52);
        }
        catch (Exception e) {
            wasAllowed = false;
        }
        Assert.assertEquals((Object)wasAllowed, (Object)this.isAllowed);
    }
}

