/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActionWorkItemCol52Test
extends ColumnTestBase {
    private ActionWorkItemCol52 column1;
    private ActionWorkItemCol52 column2;

    @Before
    public void setup() {
        this.column1 = new ActionWorkItemCol52();
        this.column1.setWorkItemDefinition(null);
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new ActionWorkItemCol52();
        this.column2.setWorkItemDefinition(null);
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testWorkItemDefinition_SimpleAndNull() {
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        this.column1.setWorkItemDefinition(def1);
        this.column2.setWorkItemDefinition(null);
        this.checkSingleDiff("workItemDefinitionName", (Object)"def1name", null, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testWorkItemDefinition_ParamAndNull() {
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        PortableStringParameterDefinition param1 = new PortableStringParameterDefinition();
        param1.setName("param1");
        param1.setValue("value1");
        def1.addParameter((PortableParameterDefinition)param1);
        this.column1.setWorkItemDefinition(null);
        this.column2.setWorkItemDefinition(def1);
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)3L, (long)diff.size());
        Assert.assertEquals((Object)"workItemDefinitionName", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)"def1name", (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterName", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"param1", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterValue", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"\"value1\"", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
    }

    @Test
    public void testWorkItemDefinition_TwoComplexDefs() {
        PortableStringParameterDefinition param1 = new PortableStringParameterDefinition();
        param1.setName("param1");
        param1.setValue("value1");
        PortableStringParameterDefinition param2 = new PortableStringParameterDefinition();
        param2.setName("param2");
        param2.setValue("value2");
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        def1.addParameter((PortableParameterDefinition)param1);
        def1.addParameter((PortableParameterDefinition)param2);
        PortableStringParameterDefinition param3 = new PortableStringParameterDefinition();
        param3.setName("param3");
        param3.setValue("value3");
        PortableStringParameterDefinition param4 = new PortableStringParameterDefinition();
        param4.setName("param1");
        param4.setValue("value1");
        PortableStringParameterDefinition param5 = new PortableStringParameterDefinition();
        param5.setName("param5");
        param5.setBinding("binding5");
        PortableStringParameterDefinition param6 = new PortableStringParameterDefinition();
        param6.setName("param2");
        param6.setValue("value6");
        PortableWorkDefinition def2 = new PortableWorkDefinition();
        def2.setName("def2name");
        def2.addParameter((PortableParameterDefinition)param3);
        def2.addParameter((PortableParameterDefinition)param4);
        def2.addParameter((PortableParameterDefinition)param5);
        def2.addParameter((PortableParameterDefinition)param6);
        this.column1.setWorkItemDefinition(def1);
        this.column2.setWorkItemDefinition(def2);
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        for (BaseColumnFieldDiff item : diff) {
            System.out.println(item.getFieldName());
            System.out.println(item.getOldValue());
            System.out.println(item.getValue());
        }
        Assert.assertEquals((long)6L, (long)diff.size());
        Assert.assertEquals((Object)"workItemDefinitionName", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)"def1name", (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)"def2name", (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterName", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"param3", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterValue", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"\"value3\"", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterName", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"param5", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterValue", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals(null, (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)"binding5", (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionParameterValue", (Object)((BaseColumnFieldDiff)diff.get(5)).getFieldName());
        Assert.assertEquals((Object)"\"value2\"", (Object)((BaseColumnFieldDiff)diff.get(5)).getOldValue());
        Assert.assertEquals((Object)"\"value6\"", (Object)((BaseColumnFieldDiff)diff.get(5)).getValue());
    }

    @Test
    public void testDiffAll() {
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        this.column1.setWorkItemDefinition(def1);
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        PortableWorkDefinition def2 = new PortableWorkDefinition();
        def2.setName("def2name");
        this.column2.setWorkItemDefinition(def2);
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)4L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"workItemDefinitionName", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)"def1name", (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"def2name", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
    }
}

