/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.utils.KieHelper;

public class GuidedDTableParsingIntegrationTest {
    @Test
    public void testGuidedDTableWithDSLSuccessfullyCompiled() {
        String personDrl = "package org.drools.test\ndeclare Person\n  adult : boolean\nend";
        String personDsl = "[when]When the person is adult = person:org.drools.test.Person(adult==\"true\")";
        String guidedDTable = "<decision-table52>\n  <tableName>test</tableName>\n  <rowNumberCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </rowNumberCol>\n  <descriptionCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </descriptionCol>\n  <metadataCols/>\n  <attributeCols/>\n  <conditionPatterns>\n    <org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn>\n      <hideColumn>false</hideColumn>\n      <width>-1</width>\n      <header>test</header>\n      <constraintValueType>1</constraintValueType>\n      <parameters/>\n      <definition>\n        <org.drools.workbench.models.datamodel.rule.DSLSentence>\n          <drl>person:org.drools.test.Person(adult==\"true\")</drl>\n          <definition>When the person is adult</definition>\n          <values>\n            <org.drools.workbench.models.datamodel.rule.DSLVariableValue>\n              <value>false</value>\n            </org.drools.workbench.models.datamodel.rule.DSLVariableValue>\n          </values>\n        </org.drools.workbench.models.datamodel.rule.DSLSentence>\n      </definition>\n      <childColumns>\n        <org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn>\n          <hideColumn>false</hideColumn>\n          <width>-1</width>\n          <header>test</header>\n          <constraintValueType>1</constraintValueType>\n          <fieldType>Boolean</fieldType>\n          <parameters/>\n          <varName></varName>\n        </org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn>\n      </childColumns>\n    </org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn>\n  </conditionPatterns>\n  <actionCols/>\n  <auditLog>\n    <filter class=\"org.drools.guvnor.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter\">\n      <acceptedTypes>\n        <entry>\n          <string>INSERT_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>INSERT_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>UPDATE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n      </acceptedTypes>\n    </filter>\n    <entries/>\n  </auditLog>\n  <packageName>org.drools.test</packageName>\n  <tableFormat>EXTENDED_ENTRY</tableFormat>\n  <data>\n    <list>\n      <value>\n        <valueNumeric class=\"int\">1</valueNumeric>\n        <valueString></valueString>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString></valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueBoolean>false</valueBoolean>\n        <valueString></valueString>\n        <dataType>BOOLEAN</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n    <list>\n      <value>\n        <valueNumeric class=\"int\">2</valueNumeric>\n        <valueString></valueString>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString></valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueBoolean>true</valueBoolean>\n        <valueString></valueString>\n        <dataType>BOOLEAN</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n  </data>\n</decision-table52>";
        KieHelper kieHelper = new KieHelper();
        kieHelper.addContent(personDrl, ResourceType.DRL);
        kieHelper.addContent(personDsl, ResourceType.DSL);
        kieHelper.addContent(guidedDTable, ResourceType.GDST);
        Results buildResults = kieHelper.verify();
        Assert.assertEquals((String)"No build failures", Collections.emptyList(), (Object)buildResults.getMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = kieHelper.build(new KieBaseOption[0]);
        Assert.assertNotNull((String)"Rule generated from guided dtable not found!", (Object)kieBase.getRule("org.drools.test", "Row 1 test"));
    }

    @Test
    public void testGuidedDTableWithNoDSLSuccessfullyCompiled() {
        String personDrl = "package org.drools.test\ndeclare Person\n  adult : boolean\nend";
        String guidedDTable = "<decision-table52>\n  <tableName>test1</tableName>\n  <rowNumberCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </rowNumberCol>\n  <descriptionCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </descriptionCol>\n  <metadataCols/>\n  <attributeCols/>\n  <conditionPatterns>\n    <Pattern52>\n      <factType>org.drools.test.Person</factType>\n      <boundName>person</boundName>\n      <isNegated>false</isNegated>\n      <conditions>\n        <condition-column52>\n          <typedDefaultValue>\n            <valueBoolean>false</valueBoolean>\n            <valueString></valueString>\n            <dataType>BOOLEAN</dataType>\n            <isOtherwise>false</isOtherwise>\n          </typedDefaultValue>\n          <hideColumn>false</hideColumn>\n          <width>-1</width>\n          <header>Header</header>\n          <constraintValueType>1</constraintValueType>\n          <factField>adult</factField>\n          <fieldType>Boolean</fieldType>\n          <operator>==</operator>\n          <parameters/>\n        </condition-column52>\n      </conditions>\n      <window>\n        <parameters/>\n      </window>\n    </Pattern52>\n  </conditionPatterns>\n  <actionCols/>\n  <auditLog>\n    <filter class=\"org.drools.guvnor.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter\">\n      <acceptedTypes>\n        <entry>\n          <string>INSERT_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>INSERT_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>UPDATE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n      </acceptedTypes>\n    </filter>\n    <entries/>\n  </auditLog>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.test</packageName>\n  <tableFormat>EXTENDED_ENTRY</tableFormat>\n  <data>\n    <list>\n      <value>\n        <valueNumeric class=\"int\">1</valueNumeric>\n        <valueString></valueString>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString></valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueBoolean>true</valueBoolean>\n        <valueString></valueString>\n        <dataType>BOOLEAN</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n  </data>\n</decision-table52>";
        KieHelper kieHelper = new KieHelper();
        kieHelper.addContent(personDrl, ResourceType.DRL);
        kieHelper.addContent(guidedDTable, ResourceType.GDST);
        Results buildResults = kieHelper.verify();
        Assert.assertEquals((String)"No build failures", Collections.emptyList(), (Object)buildResults.getMessages(new Message.Level[]{Message.Level.ERROR}));
        KieBase kieBase = kieHelper.build(new KieBaseOption[0]);
        Assert.assertNotNull((String)"Rule generated from guided dtable not found!", (Object)kieBase.getRule("org.drools.test", "Row 1 test1"));
    }

    @Test
    public void testGuidedDTableWithNoDSLIncrementalCompilation() {
        String typeDrl = "package org.drools.test\ndeclare LoanApplication\n  amount : int\nend";
        String brokenDrlGenerated = "<decision-table52>\n  <tableName>Pricing loans</tableName>\n  <rowNumberCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </rowNumberCol>\n  <descriptionCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </descriptionCol>\n  <metadataCols/>\n  <attributeCols/>\n  <conditionPatterns>\n    <Pattern52>\n      <factType>org.drools.test.LoanApplication</factType>\n      <boundName>application</boundName>\n      <isNegated>false</isNegated>\n      <conditions>\n        <condition-column52>\n          <typedDefaultValue>\n            <valueString></valueString>\n            <dataType>STRING</dataType>\n            <isOtherwise>false</isOtherwise>\n          </typedDefaultValue>\n          <hideColumn>false</hideColumn>\n          <width>-1</width>\n          <header>aa</header>\n          <constraintValueType>1</constraintValueType>\n          <factField>amount</factField>\n          <fieldType>Integer</fieldType>\n          <operator>==</operator>\n          <valueList>a,b</valueList>\n          <parameters/>\n        </condition-column52>\n      </conditions>\n      <window>\n        <parameters/>\n      </window>\n      <entryPointName></entryPointName>\n    </Pattern52>\n  </conditionPatterns>\n  <actionCols/>\n  <auditLog>\n    <filter class=\"org.drools.guvnor.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter\">\n      <acceptedTypes>\n        <entry>\n          <string>INSERT_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>INSERT_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>UPDATE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n      </acceptedTypes>\n    </filter>\n    <entries/>\n  </auditLog>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>mortgages.mortgages</packageName>\n  <tableFormat>EXTENDED_ENTRY</tableFormat>\n  <hitPolicy>NONE</hitPolicy>\n  <data>\n    <list>\n      <value>\n        <valueNumeric class=\"int\">1</valueNumeric>\n        <valueString></valueString>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString></valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString>a</valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n  </data>\n</decision-table52>";
        String correctDrlGenerated = "<decision-table52>\n  <tableName>Pricing loans</tableName>\n  <rowNumberCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </rowNumberCol>\n  <descriptionCol>\n    <hideColumn>false</hideColumn>\n    <width>-1</width>\n  </descriptionCol>\n  <metadataCols/>\n  <attributeCols/>\n  <conditionPatterns>\n    <Pattern52>\n      <factType>org.drools.test.LoanApplication</factType>\n      <boundName>application</boundName>\n      <isNegated>false</isNegated>\n      <conditions>\n        <condition-column52>\n          <typedDefaultValue>\n            <valueString></valueString>\n            <dataType>STRING</dataType>\n            <isOtherwise>false</isOtherwise>\n          </typedDefaultValue>\n          <hideColumn>false</hideColumn>\n          <width>-1</width>\n          <header>aa</header>\n          <constraintValueType>1</constraintValueType>\n          <factField>amount</factField>\n          <fieldType>Integer</fieldType>\n          <operator>==</operator>\n          <valueList>a,b</valueList>\n          <parameters/>\n        </condition-column52>\n      </conditions>\n      <window>\n        <parameters/>\n      </window>\n      <entryPointName></entryPointName>\n    </Pattern52>\n  </conditionPatterns>\n  <actionCols/>\n  <auditLog>\n    <filter class=\"org.drools.guvnor.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter\">\n      <acceptedTypes>\n        <entry>\n          <string>INSERT_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>INSERT_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_ROW</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>DELETE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n        <entry>\n          <string>UPDATE_COLUMN</string>\n          <boolean>false</boolean>\n        </entry>\n      </acceptedTypes>\n    </filter>\n    <entries/>\n  </auditLog>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>mortgages.mortgages</packageName>\n  <tableFormat>EXTENDED_ENTRY</tableFormat>\n  <hitPolicy>NONE</hitPolicy>\n  <data>\n    <list>\n      <value>\n        <valueNumeric class=\"int\">1</valueNumeric>\n        <valueString></valueString>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueString></valueString>\n        <dataType>STRING</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n      <value>\n        <valueNumeric class=\"int\">1000</valueNumeric>\n        <dataType>NUMERIC_INTEGER</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n  </data>\n</decision-table52>";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/test/personDrl.drl", typeDrl).write("src/main/resources/dt1.gdst", brokenDrlGenerated);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results buildResults = kieBuilder.getResults();
        int errorsNr = buildResults.getMessages(new Message.Level[]{Message.Level.ERROR}).size();
        Assert.assertTrue((String)"Expected build failure", (errorsNr > 0 ? 1 : 0) != 0);
        kfs.write("src/main/resources/dt1.gdst", correctDrlGenerated);
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/dt1.gdst"}).build();
        Assert.assertEquals((long)0L, (long)results.getAddedMessages().size());
        Assert.assertEquals((long)errorsNr, (long)results.getRemovedMessages().size());
    }
}

