/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AttributeCol52Test
extends ColumnTestBase {
    private AttributeCol52 column1;
    private AttributeCol52 column2;

    @Before
    public void setup() {
        this.column1 = new AttributeCol52();
        this.column1.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.column1.setReverseOrder(false);
        this.column1.setUseRowNumber(false);
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new AttributeCol52();
        this.column2.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.column2.setReverseOrder(false);
        this.column2.setUseRowNumber(false);
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffAttribute() {
        this.column1.setAttribute(Attribute.ACTIVATION_GROUP.getAttributeName());
        this.column2.setAttribute(Attribute.ENABLED.getAttributeName());
        this.checkSingleDiff("attribute", (Object)Attribute.ACTIVATION_GROUP.getAttributeName(), (Object)Attribute.ENABLED.getAttributeName(), (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffRevesreOrder() {
        this.column1.setReverseOrder(false);
        this.column2.setReverseOrder(true);
        this.checkSingleDiff("reverseOrder", (Object)false, (Object)true, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffUseRowNumber() {
        this.column1.setUseRowNumber(false);
        this.column2.setUseRowNumber(true);
        this.checkSingleDiff("useRowNumber", (Object)false, (Object)true, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.column1.setReverseOrder(false);
        this.column1.setUseRowNumber(false);
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setAttribute(Attribute.ACTIVATION_GROUP.getAttributeName());
        this.column2.setReverseOrder(true);
        this.column2.setUseRowNumber(true);
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)6L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"attribute", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)Attribute.SALIENCE.getAttributeName(), (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)Attribute.ACTIVATION_GROUP.getAttributeName(), (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"reverseOrder", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
        Assert.assertEquals((Object)"useRowNumber", (Object)((BaseColumnFieldDiff)diff.get(5)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(5)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(5)).getValue());
    }

    @Test
    public void testCloneColumn() {
        this.column1.setWidth(10);
        AttributeCol52 clone = this.column1.cloneColumn();
        Assert.assertEquals((Object)this.column1.getAttribute(), (Object)clone.getAttribute());
        Assert.assertEquals((Object)this.column1.isReverseOrder(), (Object)clone.isReverseOrder());
        Assert.assertEquals((Object)this.column1.isUseRowNumber(), (Object)clone.isUseRowNumber());
        Assert.assertEquals((Object)this.column1.getHeader(), (Object)clone.getHeader());
        Assert.assertEquals((long)this.column1.getWidth(), (long)clone.getWidth());
        Assert.assertEquals((Object)this.column1.isHideColumn(), (Object)clone.isHideColumn());
        Assert.assertEquals((Object)this.column1.getDefaultValue(), (Object)clone.getDefaultValue());
    }
}

