/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Pattern52Test
extends ColumnTestBase {
    private Pattern52 column1;
    private Pattern52 column2;

    @Before
    public void setup() {
        this.column1 = new Pattern52();
        this.column1.setFactType("Fact");
        this.column1.setBoundName("$var");
        this.column1.setNegated(false);
        this.column1.setWindow(new CEPWindow());
        this.column1.setEntryPointName("entryPoint");
        this.column2 = new Pattern52();
        this.column2.setFactType("Fact");
        this.column2.setBoundName("$var");
        this.column2.setNegated(false);
        this.column2.setWindow(new CEPWindow());
        this.column2.setEntryPointName("entryPoint");
    }

    @Test
    public void testDiffEmpty() {
        Assert.assertEquals((Object)this.column1, (Object)this.column2);
        this.checkDiffEmpty(this.column1, this.column2);
    }

    @Test
    public void testDiffFactType() {
        this.column1.setFactType("Fact1");
        this.column2.setFactType("Fact2");
        this.checkSingleDiff("factType", (Object)"Fact1", (Object)"Fact2", this.column1, this.column2);
        Assert.assertNotEquals((Object)this.column1, (Object)this.column2);
    }

    @Test
    public void testDiffBoundName() {
        this.column1.setBoundName("$var1");
        this.column2.setBoundName("$var2");
        this.checkSingleDiff("boundName", (Object)"$var1", (Object)"$var2", this.column1, this.column2);
        Assert.assertNotEquals((Object)this.column1, (Object)this.column2);
    }

    @Test
    public void testDiffNegated() {
        this.column1.setNegated(false);
        this.column2.setNegated(true);
        this.checkSingleDiff("isNegated", (Object)false, (Object)true, this.column1, this.column2);
        Assert.assertNotEquals((Object)this.column1, (Object)this.column2);
    }

    @Test
    public void testDiffWindow() {
        CEPWindow window1 = new CEPWindow();
        window1.setOperator("dummyOp1");
        this.column1.setWindow(window1);
        CEPWindow window2 = new CEPWindow();
        window2.setOperator("dummyOp2");
        this.column2.setWindow(window2);
        this.checkSingleDiff("window", (Object)window1, (Object)window2, this.column1, this.column2);
        Assert.assertNotEquals((Object)this.column1, (Object)this.column2);
    }

    @Test
    public void testDiffEntryPoint() {
        this.column1.setEntryPointName("entryPoint1");
        this.column2.setEntryPointName("entryPoint2");
        this.checkSingleDiff("entryPointName", (Object)"entryPoint1", (Object)"entryPoint2", this.column1, this.column2);
        Assert.assertNotEquals((Object)this.column1, (Object)this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setFactType("Fact1");
        this.column1.setBoundName("$var1");
        this.column1.setNegated(false);
        CEPWindow window1 = new CEPWindow();
        window1.setOperator("dummyOp1");
        this.column1.setWindow(window1);
        this.column1.setEntryPointName("entryPoint1");
        this.column2.setFactType("Fact2");
        this.column2.setBoundName("$var2");
        this.column2.setNegated(true);
        CEPWindow window2 = new CEPWindow();
        window2.setOperator("dummyOp2");
        this.column2.setWindow(window2);
        this.column2.setEntryPointName("entryPoint2");
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)5L, (long)diff.size());
        Assert.assertEquals((Object)"factType", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)"Fact1", (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)"Fact2", (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"boundName", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"$var1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"$var2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"isNegated", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"window", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)window1, (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)window2, (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"entryPointName", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals((Object)"entryPoint1", (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)"entryPoint2", (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
    }

    @Test
    public void testCloneColumn() {
        Pattern52 clone = this.column1.clonePattern();
        Assert.assertEquals((Object)this.column1.getFactType(), (Object)clone.getFactType());
        Assert.assertEquals((Object)this.column1.getBoundName(), (Object)clone.getBoundName());
        Assert.assertEquals((Object)this.column1.getWindow(), (Object)clone.getWindow());
        Assert.assertEquals((Object)this.column1.getEntryPointName(), (Object)clone.getEntryPointName());
        Assert.assertEquals((Object)this.column1.isNegated(), (Object)clone.isNegated());
        Assert.assertEquals((Object)this.column1, (Object)clone);
    }
}

