/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActionSetFieldCol52Test
extends ColumnTestBase {
    private ActionSetFieldCol52 column1;
    private ActionSetFieldCol52 column2;

    @Before
    public void setup() {
        this.column1 = new ActionSetFieldCol52();
        this.column1.setBoundName("$var");
        this.column1.setFactField("field");
        this.column1.setType("Type");
        this.column1.setValueList("a,b,c");
        this.column1.setUpdate(false);
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new ActionSetFieldCol52();
        this.column2.setBoundName("$var");
        this.column2.setFactField("field");
        this.column2.setType("Type");
        this.column2.setValueList("a,b,c");
        this.column2.setUpdate(false);
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffBoundName() {
        this.column1.setBoundName("$var1");
        this.column2.setBoundName("$var2");
        this.checkSingleDiff("boundName", (Object)"$var1", (Object)"$var2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffFactField() {
        this.column1.setFactField("field1");
        this.column2.setFactField("field2");
        this.checkSingleDiff("factField", (Object)"field1", (Object)"field2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffType() {
        this.column1.setType("Type1");
        this.column2.setType("Type2");
        this.checkSingleDiff("type", (Object)"Type1", (Object)"Type2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffValueList() {
        this.column1.setValueList("a,b");
        this.column2.setValueList("b,c");
        this.checkSingleDiff("valueList", (Object)"a,b", (Object)"b,c", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffUpdate() {
        this.column1.setUpdate(false);
        this.column2.setUpdate(true);
        this.checkSingleDiff("update", (Object)false, (Object)true, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setBoundName("$var1");
        this.column1.setFactField("field1");
        this.column1.setType("Type1");
        this.column1.setValueList("a,b");
        this.column1.setUpdate(false);
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setBoundName("$var2");
        this.column2.setFactField("field2");
        this.column2.setType("Type2");
        this.column2.setValueList("b,c");
        this.column2.setUpdate(true);
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)8L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"boundName", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)"$var1", (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"$var2", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"factField", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals((Object)"field1", (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)"field2", (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
        Assert.assertEquals((Object)"type", (Object)((BaseColumnFieldDiff)diff.get(5)).getFieldName());
        Assert.assertEquals((Object)"Type1", (Object)((BaseColumnFieldDiff)diff.get(5)).getOldValue());
        Assert.assertEquals((Object)"Type2", (Object)((BaseColumnFieldDiff)diff.get(5)).getValue());
        Assert.assertEquals((Object)"valueList", (Object)((BaseColumnFieldDiff)diff.get(6)).getFieldName());
        Assert.assertEquals((Object)"a,b", (Object)((BaseColumnFieldDiff)diff.get(6)).getOldValue());
        Assert.assertEquals((Object)"b,c", (Object)((BaseColumnFieldDiff)diff.get(6)).getValue());
        Assert.assertEquals((Object)"update", (Object)((BaseColumnFieldDiff)diff.get(7)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(7)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(7)).getValue());
    }
}

