/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.hitpolicy;

import org.drools.workbench.models.guided.dtable.shared.hitpolicy.RowNumber;
import org.drools.workbench.models.guided.dtable.shared.hitpolicy.RowPriorities;
import org.drools.workbench.models.guided.dtable.shared.hitpolicy.RowPriorityResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RowPriorityResolverTest {
    private RowPriorityResolver rowPriorityResolver;
    private RowPriorities priorities;

    @Before
    public void setUp() throws Exception {
        this.rowPriorityResolver = new RowPriorityResolver();
    }

    @After
    public void tearDown() throws Exception {
        this.rowPriorityResolver = null;
        this.priorities = null;
    }

    @Test
    public void noPrioritiesSet() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(3, 0);
        this.rowPriorityResolver.set(2, 0);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(2, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(3)));
    }

    @Test
    public void simple2Row() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(0, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(2)));
    }

    @Test
    public void simple3Row() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 2);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(2, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(3)));
    }

    @Test
    public void when2rowsHavePriorityOverTheSameRow() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.rowPriorityResolver.set(3, 1);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(0, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(3)));
    }

    @Test
    public void complex() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 1);
        this.rowPriorityResolver.set(4, 2);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(2, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(4)));
    }

    @Test
    public void complex2() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 2);
        this.rowPriorityResolver.set(4, 1);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(2, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(4)));
    }

    @Test
    public void reverseOrder() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.rowPriorityResolver.set(3, 2);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(0, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(3)));
    }

    @Test
    public void twoReverseOrders() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.rowPriorityResolver.set(3, 2);
        this.rowPriorityResolver.set(4, 0);
        this.rowPriorityResolver.set(5, 4);
        this.rowPriorityResolver.set(6, 5);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(3, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(4, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(5, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(4)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(5)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(6)));
    }

    @Test
    public void complex3() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.rowPriorityResolver.set(3, 2);
        this.rowPriorityResolver.set(4, 1);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(0, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(4)));
    }

    @Test
    public void complex4() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 0);
        this.rowPriorityResolver.set(4, 3);
        this.rowPriorityResolver.set(5, 2);
        this.rowPriorityResolver.set(6, 1);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(4, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(4)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(5)));
        this.assertSalience(5, new RowNumber(Integer.valueOf(6)));
    }

    @Test
    public void testMultipleRowsHasPriorityOverTheSameRow() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 1);
        this.rowPriorityResolver.set(3, 1);
        this.rowPriorityResolver.set(4, 1);
        this.rowPriorityResolver.set(5, 2);
        this.rowPriorityResolver.set(6, 2);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(0, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(4)));
        this.assertSalience(5, new RowNumber(Integer.valueOf(5)));
        this.assertSalience(4, new RowNumber(Integer.valueOf(6)));
    }

    @Test
    public void testPriorityOverGroup() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 0);
        this.rowPriorityResolver.set(4, 1);
        this.rowPriorityResolver.set(5, 3);
        this.rowPriorityResolver.set(6, 5);
        this.rowPriorityResolver.set(7, 1);
        this.rowPriorityResolver.set(8, 3);
        this.rowPriorityResolver.set(9, 3);
        this.rowPriorityResolver.set(10, 7);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(6, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(5, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(9, new RowNumber(Integer.valueOf(4)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(5)));
        this.assertSalience(4, new RowNumber(Integer.valueOf(6)));
        this.assertSalience(7, new RowNumber(Integer.valueOf(7)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(8)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(9)));
        this.assertSalience(8, new RowNumber(Integer.valueOf(10)));
    }

    @Test
    public void twoSeparatePriorityGroups() throws Exception {
        this.rowPriorityResolver.set(1, 0);
        this.rowPriorityResolver.set(2, 0);
        this.rowPriorityResolver.set(3, 2);
        this.rowPriorityResolver.set(4, 0);
        this.rowPriorityResolver.set(5, 4);
        this.rowPriorityResolver.set(6, 5);
        this.priorities = this.rowPriorityResolver.getPriorityRelations();
        this.assertSalience(5, new RowNumber(Integer.valueOf(1)));
        this.assertSalience(3, new RowNumber(Integer.valueOf(2)));
        this.assertSalience(4, new RowNumber(Integer.valueOf(3)));
        this.assertSalience(0, new RowNumber(Integer.valueOf(4)));
        this.assertSalience(1, new RowNumber(Integer.valueOf(5)));
        this.assertSalience(2, new RowNumber(Integer.valueOf(6)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void priorityOverLowerRow() throws Exception {
        this.rowPriorityResolver.set(1, 4);
    }

    private void assertSalience(Integer expected, RowNumber rowNumber) {
        Assert.assertEquals((Object)expected, (Object)this.priorities.getSalience(rowNumber).getSalience());
    }
}

