/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.TemplateAware;
import org.drools.workbench.models.guided.dtable.backend.util.GuidedDTBRDRLPersistence;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDTBRDRLPersistenceTest {
    @Test
    public void testRHSWithTemplateAwareIAction() {
        GuidedDTBRDRLPersistence persistence = new GuidedDTBRDRLPersistence(key -> "value");
        RuleModel ruleModel = new RuleModel();
        ruleModel.name = "Template aware";
        ruleModel.addRhsItem((IAction)new TemplateAwareIAction("initialValue"));
        String result = persistence.marshal(ruleModel);
        String expected = "rule \"Template aware\"\n\tdialect \"mvel\"\n\twhen\n\tthen\n\t\tsubstitutedValue;\nend\n";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static class TemplateAwareIAction
    implements IAction,
    TemplateAware,
    PluggableIAction {
        private String value;

        public TemplateAwareIAction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Collection<InterpolationVariable> extractInterpolationVariables() {
            return Arrays.asList(new InterpolationVariable("test", "Object"));
        }

        public void substituteTemplateVariables(Function<String, String> keyToValueFunction) {
            this.value = "substitutedValue";
        }

        public TemplateAware cloneTemplateAware() {
            return new TemplateAwareIAction(this.value);
        }

        public String getStringRepresentation() {
            return this.value;
        }
    }
}

