/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.backend.TestUtil;
import org.drools.workbench.models.guided.dtable.backend.util.DataUtilities;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.junit.Before;
import org.junit.Test;

public class GuidedDTDRLPersistenceUniqueHitPolicyTest {
    private GuidedDecisionTable52 dtable;

    @Before
    public void setUp() throws Exception {
        this.dtable = new GuidedDecisionTable52();
        this.dtable.setTableName("Unique hit policy table");
        this.dtable.setHitPolicy(GuidedDecisionTable52.HitPolicy.UNIQUE_HIT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void blockUseOfActivationGroup() {
        AttributeCol52 attributeCol52 = new AttributeCol52();
        attributeCol52.setAttribute("activation-group");
        attributeCol52.setDefaultValue(new DTCellValue52("test"));
        this.dtable.getAttributeCols().add(attributeCol52);
        GuidedDTDRLPersistence.getInstance().marshal(this.dtable);
    }

    @Test
    public void allRulesHaveTheSameActivationGroup() throws Exception {
        this.dtable.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1, "desc-row1"}, {2, "desc-row2"}, {3, "desc-row3"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(this.dtable);
        TestUtil.assertContainsLinesInOrder(drl, "rule \"Row 1 Unique hit policy table\"", "activation-group \"unique-hit-policy-group Unique hit policy table\"", "rule \"Row 2 Unique hit policy table\"", "activation-group \"unique-hit-policy-group Unique hit policy table\"", "rule \"Row 3 Unique hit policy table\"", "activation-group \"unique-hit-policy-group Unique hit policy table\"");
    }
}

