/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseBRLTest;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BRLRuleModelTest
extends BaseBRLTest {
    private BRLRuleModel rm;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.rm = new BRLRuleModel(this.dtable);
    }

    @Test
    public void getLHSBoundFactsWithNoDefinition() {
        this.assertThereAreNoBindings();
    }

    @Test
    public void getLHSBoundFactsWithPattern() {
        this.whenThereIsAPattern("Applicant", "$a");
        this.assertThereIsLHSBindingFor("$a");
    }

    @Test
    public void getLHSBoundFactsWithFactPattern() {
        this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.assertThereIsLHSBindingFor("$a");
    }

    @Test
    public void getLHSBoundFactsWithFromCompositeFactPattern() {
        this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.assertThereIsLHSBindingFor("$a");
    }

    @Test
    public void getLHSBoundFactWithPattern() {
        this.whenThereIsAPattern("Applicant", "$a");
        this.assertThereIsABoundFactFor("$a");
    }

    @Test
    public void getLHSBoundFactWithFactPattern() {
        this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.assertThereIsABoundFactFor("$a");
    }

    @Test
    public void getLHSBoundFactWithFromCompositeFactPattern() {
        this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.assertThereIsABoundFactFor("$a");
    }

    @Test
    public void getLHSBindingTypeWithPattern() {
        this.whenThereIsAPattern("Applicant", "$a");
        this.assertLHSBindingTypeFor("Applicant", "$a");
    }

    @Test
    public void getLHSBindingTypeWithFactPattern() {
        this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.assertLHSBindingTypeFor("Applicant", "$a");
    }

    @Test
    public void getLHSBindingTypeWithFromCompositeFactPattern() {
        this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.assertLHSBindingTypeFor("Applicant", "$a");
    }

    @Test
    public void getLHSBoundFieldWithPatternField() {
        Pattern52 p = this.whenThereIsAPattern("Applicant", "$a");
        this.whenPatternHasAField(p, "field1", "String", "$f");
        this.assertThereIsAFieldBindingFor("$f");
    }

    @Test
    public void getLHSBoundFieldWithFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.whenBRLFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertThereIsAFieldBindingFor("$f");
    }

    @Test
    public void getLHSBoundFieldWithFromCompositeFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.whenBRLFromCompositeFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertThereIsAFieldBindingFor("$f");
    }

    @Test
    public void getLHSBindingTypeWithPatternField() {
        Pattern52 p = this.whenThereIsAPattern("Applicant", "$a");
        this.whenPatternHasAField(p, "field1", "String", "$f");
        this.assertLHSBindingTypeFor("String", "$f");
    }

    @Test
    public void getLHSBindingTypeWithFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.whenBRLFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertLHSBindingTypeFor("String", "$f");
    }

    @Test
    public void getLHSBindingTypeWithFromCompositeFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.whenBRLFromCompositeFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertLHSBindingTypeFor("String", "$f");
    }

    @Test
    public void getLHSParentFactPatternForBindingWithPatternField() {
        Pattern52 p = this.whenThereIsAPattern("Applicant", "$a");
        this.whenPatternHasAField(p, "field1", "String", "$f");
        this.assertLHSParentFactPatternFor("$a", "$f");
    }

    @Test
    public void getLHSParentFactPatternForBindingWithFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFactPattern("Applicant", "$a");
        this.whenBRLFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertLHSParentFactPatternFor("$a", "$f");
    }

    @Test
    public void getLHSParentFactPatternForBindingWithFromCompositeFactPatternField() {
        BRLConditionColumn brl = this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a");
        this.whenBRLFromCompositeFactPatternHasAField(brl, "field1", "String", "$f");
        this.assertLHSParentFactPatternFor("$a", "$f");
    }

    @Test
    public void getAllLHSVariables() {
        Pattern52 p = this.whenThereIsAPattern("Applicant", "$a1");
        this.whenPatternHasAField(p, "field1", "String", "$f1");
        BRLConditionColumn brl1 = this.whenThereIsABRLFactPattern("Applicant", "$a2");
        this.whenBRLFactPatternHasAField(brl1, "field1", "String", "$f2");
        BRLConditionColumn brl2 = this.whenThereIsABRLFromCompositeFactPattern("Applicant", "$a3");
        this.whenBRLFromCompositeFactPatternHasAField(brl2, "field1", "String", "$f3");
        this.assertLHSBindings("$a1", "$a2", "$a3", "$f1", "$f2", "$f3");
    }

    @Test
    public void checkGetAllLHSVariables() {
        this.whenThereIsADecisionTableWithPatternsAndBRLCondition();
        this.assertThereAreBindings(() -> this.rm.getAllLHSVariables(), "$p1", "$p2", "$p3", "$p4", "$f1", "$f2");
    }

    @Test
    public void checkGetLHSPatternVariables() {
        this.whenThereIsADecisionTableWithPatternsAndBRLCondition();
        this.assertThereAreBindings(() -> this.rm.getLHSPatternVariables(), "$p1", "$p2", "$p3", "$p4");
    }

    @Test
    public void checkGetLHSFieldVariables() {
        this.whenThereIsADecisionTableWithPatternsAndBRLCondition();
        this.assertThereAreBindings(() -> this.rm.getLHSVariables(false, true), "$f1", "$f2");
    }

    private ConditionCol52 whenPatternHasAField(Pattern52 p, String fieldName, String fieldType, String fieldBinding) {
        ConditionCol52 c = new ConditionCol52();
        c.setFactField(fieldName);
        c.setFieldType(fieldType);
        c.setBinding(fieldBinding);
        p.getChildColumns().add(c);
        return c;
    }

    private void whenThereIsADecisionTableWithPatternsAndBRLCondition() {
        Pattern52 p1 = this.whenThereIsAPattern("Pattern", "$p1");
        this.whenPatternHasAField(p1, "field1", "fieldType", "$f1");
        BRLConditionColumn brlConditionColumn = this.whenThereIsABRLFactPattern("Fact", "$p2");
        this.whenBRLFactPatternHasAField(brlConditionColumn, "field1", "fieldType", "$f2");
        this.whenThereIsABRLFromCompositeFactPattern("Fact", "$p3");
        this.whenThereIsABRLFromCompositeFactPattern("Fact", "$p4");
    }

    private void assertThereAreNoBindings() {
        List result = this.rm.getLHSBoundFacts();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    private void assertThereIsLHSBindingFor(String binding) {
        List result = this.rm.getLHSBoundFacts();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)binding, result.get(0));
    }

    private void assertThereIsABoundFactFor(String binding) {
        FactPattern result = this.rm.getLHSBoundFact(binding);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)binding, (Object)result.getBoundName());
    }

    private void assertThereIsAFieldBindingFor(String fieldBinding) {
        SingleFieldConstraint sfc = this.rm.getLHSBoundField(fieldBinding);
        Assert.assertNotNull((Object)sfc);
    }

    private void assertLHSBindingTypeFor(String expectedType, String binding) {
        String actualType = this.rm.getLHSBindingType(binding);
        Assert.assertEquals((Object)expectedType, (Object)actualType);
    }

    private void assertLHSParentFactPatternFor(String patternBinding, String fieldBinding) {
        FactPattern boundPattern1 = this.rm.getLHSParentFactPatternForBinding(patternBinding);
        Assert.assertNotNull((Object)boundPattern1);
        Assert.assertEquals((Object)patternBinding, (Object)boundPattern1.getBoundName());
        FactPattern boundPattern2 = this.rm.getLHSParentFactPatternForBinding(fieldBinding);
        Assert.assertNotNull((Object)boundPattern2);
        Assert.assertEquals((Object)patternBinding, (Object)boundPattern2.getBoundName());
    }

    private void assertLHSBindings(String ... expectedBindings) {
        List actualBindings = this.rm.getAllLHSVariables();
        Assert.assertNotNull((Object)actualBindings);
        Assert.assertEquals((long)expectedBindings.length, (long)actualBindings.size());
        Arrays.asList(expectedBindings).stream().forEach(actualBindings::contains);
    }

    protected void assertThereAreBindings(Supplier<List<String>> actualBindingSupplier, String ... expectedBindings) {
        List<String> actualBindings = actualBindingSupplier.get();
        Assert.assertEquals((long)actualBindings.size(), (long)expectedBindings.length);
        Assert.assertTrue((boolean)actualBindings.containsAll(Arrays.asList(expectedBindings)));
    }
}

