/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseBRLTest {
    protected GuidedDecisionTable52 dtable;

    @Before
    public void setup() {
        this.dtable = new GuidedDecisionTable52();
    }

    protected Pattern52 whenThereIsAPattern(String factType, String binding) {
        Pattern52 p = new Pattern52();
        p.setFactType(factType);
        p.setBoundName(binding);
        this.dtable.getConditions().add(p);
        return p;
    }

    protected BRLConditionColumn whenThereIsABRLFactPattern(String factType, String binding) {
        FactPattern fp = new FactPattern(factType);
        fp.setBoundName(binding);
        BRLConditionColumn brl = new BRLConditionColumn();
        brl.getDefinition().add(fp);
        this.dtable.getConditions().add(brl);
        return brl;
    }

    protected BRLConditionColumn whenThereIsABRLFromCompositeFactPattern(String factType, String binding) {
        FromCompositeFactPattern fcfp = new FromCompositeFactPattern();
        FactPattern fp = new FactPattern(factType);
        fp.setBoundName(binding);
        fcfp.setFactPattern(fp);
        BRLConditionColumn brl = new BRLConditionColumn();
        brl.getDefinition().add(fcfp);
        this.dtable.getConditions().add(brl);
        return brl;
    }

    protected SingleFieldConstraint whenBRLFactPatternHasAField(BRLConditionColumn brl, String fieldName, String fieldType, String fieldBinding) {
        Assert.assertFalse((String)"BRLConditionColumn has not been initialised. Was 'whenThereIsABRLFactPattern' called?", (boolean)brl.getDefinition().isEmpty());
        Assert.assertEquals((String)"BRLConditionColumn has not been initialised correctly. Was 'whenThereIsABRLFactPattern' called?", (long)1L, (long)brl.getDefinition().size());
        Assert.assertTrue((String)"BRLConditionColumn has not been initialised correctly. Was 'whenThereIsABRLFactPattern' called?", (boolean)(brl.getDefinition().get(0) instanceof FactPattern));
        FactPattern fp = (FactPattern)brl.getDefinition().get(0);
        SingleFieldConstraint sfc = new SingleFieldConstraint();
        sfc.setFactType(fp.getFactType());
        sfc.setFieldName(fieldName);
        sfc.setFieldType(fieldType);
        sfc.setFieldBinding(fieldBinding);
        fp.addConstraint((FieldConstraint)sfc);
        brl.getDefinition().add(fp);
        return sfc;
    }

    protected SingleFieldConstraint whenBRLFromCompositeFactPatternHasAField(BRLConditionColumn brl, String fieldName, String fieldType, String fieldBinding) {
        Assert.assertFalse((String)"BRLConditionColumn has not been initialised. Was 'whenThereIsABRLFactPattern' called?", (boolean)brl.getDefinition().isEmpty());
        Assert.assertEquals((String)"BRLConditionColumn has not been initialised correctly. Was 'whenThereIsABRLFactPattern' called?", (long)1L, (long)brl.getDefinition().size());
        Assert.assertTrue((String)"BRLConditionColumn has not been initialised correctly. Was 'whenThereIsABRLFactPattern' called?", (boolean)(brl.getDefinition().get(0) instanceof FromCompositeFactPattern));
        FromCompositeFactPattern fcfp = (FromCompositeFactPattern)brl.getDefinition().get(0);
        FactPattern fp = fcfp.getFactPattern();
        SingleFieldConstraint sfc = new SingleFieldConstraint();
        sfc.setFactType(fp.getFactType());
        sfc.setFieldName(fieldName);
        sfc.setFieldType(fieldType);
        sfc.setFieldBinding(fieldBinding);
        fp.addConstraint((FieldConstraint)sfc);
        brl.getDefinition().add(fp);
        return sfc;
    }

    protected void assertThereIsNoPatternFor(String binding) {
        Pattern52 p = this.dtable.getConditionPattern(binding);
        Assert.assertNull((Object)p);
    }

    protected void assertThereIsAPatternFor(String factType, String binding) {
        Pattern52 result = this.dtable.getConditionPattern(binding);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)factType, (Object)result.getFactType());
        Assert.assertEquals((Object)binding, (Object)result.getBoundName());
    }
}

