/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.validation;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.validation.DecisionTableValidator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DecisionTableValidatorHitPolicyAttributeLimitationsTest {
    private final GuidedDecisionTable52.HitPolicy hitPolicy;
    private final String attributeName;
    private final boolean isAllowed;

    public DecisionTableValidatorHitPolicyAttributeLimitationsTest(GuidedDecisionTable52.HitPolicy hitPolicy, String attributeName, boolean isAllowed) {
        this.hitPolicy = hitPolicy;
        this.attributeName = attributeName;
        this.isAllowed = isAllowed;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> attributes() {
        return Arrays.asList({GuidedDecisionTable52.HitPolicy.NONE, "salience", true}, {GuidedDecisionTable52.HitPolicy.FIRST_HIT, "salience", false}, {GuidedDecisionTable52.HitPolicy.RULE_ORDER, "salience", false}, {GuidedDecisionTable52.HitPolicy.UNIQUE_HIT, "salience", true}, {GuidedDecisionTable52.HitPolicy.NONE, "activation-group", true}, {GuidedDecisionTable52.HitPolicy.FIRST_HIT, "activation-group", false}, {GuidedDecisionTable52.HitPolicy.RULE_ORDER, "activation-group", true}, {GuidedDecisionTable52.HitPolicy.UNIQUE_HIT, "activation-group", false});
    }

    @Test
    public void addAttributeColumn() throws Exception {
        GuidedDecisionTable52 table = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)table.getHitPolicy()).thenReturn((Object)this.hitPolicy);
        DecisionTableValidator validator = new DecisionTableValidator(table);
        AttributeCol52 attributeCol52 = new AttributeCol52();
        attributeCol52.setAttribute(this.attributeName);
        boolean wasAllowed = true;
        try {
            validator.isValidToAdd(attributeCol52);
        }
        catch (Exception e) {
            wasAllowed = false;
        }
        Assert.assertEquals((Object)wasAllowed, (Object)this.isAllowed);
    }
}

