/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import java.util.Objects;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DTColumnConfig52Test
extends ColumnTestBase {
    protected DTColumnConfig52 column1;
    protected DTColumnConfig52 column2;

    @Before
    public void setup() {
        this.column1 = new DTColumnConfig52();
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new DTColumnConfig52();
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)Objects.equals(this.column1, this.column2));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty(this.column1, this.column2);
    }

    @Test
    public void testDiffHeader() {
        this.column1.setHeader("header1");
        this.column2.setHeader("header2");
        this.checkSingleDiff("header", (Object)"header1", (Object)"header2", this.column1, this.column2);
    }

    @Test
    public void testDiffHide() {
        this.column1.setHideColumn(false);
        this.column2.setHideColumn(true);
        this.checkSingleDiff("hideColumn", (Object)false, (Object)true, this.column1, this.column2);
    }

    @Test
    public void testDiffDefaultValue() {
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setDefaultValue(new DTCellValue52(Integer.valueOf(7)));
        this.checkSingleDiff("defaultValue", (Object)"default1", (Object)7, this.column1, this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)3L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
    }
}

