/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.backend.TestUtil;
import org.drools.workbench.models.guided.dtable.backend.util.DataUtilities;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.soup.project.datamodel.oracle.DataType;

public class GuidedDTXMLPersistenceTest {
    private DataUtilities upgrader = new DataUtilities();

    @Before
    public void setUp() throws Exception {
        GuidedDTXMLPersistence.getInstance();
    }

    @Test
    public void testRoundTrip() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.getActionCols().add(new ActionInsertFactCol52());
        ActionSetFieldCol52 set = new ActionSetFieldCol52();
        set.setFactField("foo");
        dt.getActionCols().add(set);
        dt.getMetadataCols().add(new MetadataCol52());
        dt.getAttributeCols().add(new AttributeCol52());
        Pattern52 p = new Pattern52();
        ConditionCol52 c = new ConditionCol52();
        p.getChildColumns().add(c);
        dt.getConditions().add(p);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "My rule", "hola"}}));
        dt.setTableName("blah");
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        System.out.println(xml);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<version>739</version>"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ActionSetField"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ConditionCol"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("GuidedDecisionTable"));
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditions().size());
        Assert.assertEquals((long)1L, (long)((CompositeColumn)dt_.getConditions().get(0)).getChildColumns().size());
        Assert.assertEquals((Object)"My rule", (Object)((DTCellValue52)((List)dt_.getData().get(0)).get(1)).getStringValue());
    }

    @Test
    public void testBackwardsCompatibility() throws Exception {
        String xml = TestUtil.loadResource("ExistingDecisionTable.xml");
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditions().size());
        Assert.assertEquals((long)1L, (long)((CompositeColumn)dt_.getConditions().get(0)).getChildColumns().size());
        Assert.assertTrue((boolean)(dt_.getActionCols().get(1) instanceof ActionSetFieldCol52));
        ActionSetFieldCol52 asf = (ActionSetFieldCol52)dt_.getActionCols().get(1);
        Assert.assertEquals((Object)"foo", (Object)asf.getFactField());
        Assert.assertEquals((Object)false, (Object)asf.isUpdate());
        Assert.assertEquals((long)7L, (long)((List)dt_.getData().get(0)).size());
    }

    @Test
    public void testUnmarshallLegacyNumericType() {
        String guidedDTableXml = "<decision-table52>\n  <tableName>Some rules</tableName>\n  <rowNumberCol>\n    <hideColumn>false</hideColumn>\n    <width>24</width>\n  </rowNumberCol>\n  <metadataCols/>\n  <attributeCols/>\n  <conditionPatterns/>\n  <actionCols/>\n  <data>\n    <list>\n      <value>\n        <valueNumeric>1</valueNumeric>\n        <dataType>NUMERIC</dataType>\n        <isOtherwise>false</isOtherwise>\n      </value>\n    </list>\n  </data>\n</decision-table52>";
        GuidedDecisionTable52 guidedDTable = GuidedDTXMLPersistence.getInstance().unmarshal(guidedDTableXml);
        List dataList = guidedDTable.getData();
        Assertions.assertThat((List)dataList).hasSize(1);
        List cellValueList = (List)dataList.get(0);
        Assertions.assertThat((List)cellValueList).hasSize(2);
        Assertions.assertThat((Comparable)((DTCellValue52)cellValueList.get(0)).getDataType()).isEqualTo((Object)DataType.DataTypes.NUMERIC_INTEGER);
        Assertions.assertThat((int)((DTCellValue52)cellValueList.get(0)).getNumericValue().intValue()).isEqualTo(1);
    }
}

