/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.ftp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.drools.process.instance.WorkItemHandler;
import org.drools.process.workitem.email.Connection;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;

public class FTPUploadWorkItemHandler
implements WorkItemHandler {
    private String user;
    private String password;
    private String server;
    private String filePath;
    private int port;
    private FTPClient client;
    private Connection connection;
    private boolean result = false;

    public void setConnection(String host, String port, String userName, String password) {
        this.connection = new Connection();
        this.connection.setHost(host);
        this.connection.setPort(port);
        this.connection.setUserName(userName);
        this.connection.setPassword(password);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.user = (String)workItem.getParameter("User");
        this.password = (String)workItem.getParameter("Password");
        this.filePath = (String)workItem.getParameter("FilePath");
        this.client = new FTPClient();
        try {
            if (this.connection != null) {
                this.client.connect(this.connection.getHost(), Integer.parseInt(this.connection.getPort()));
                int reply = this.client.getReplyCode();
                if (FTPReply.isPositiveCompletion((int)reply) && this.client.login(this.user, this.password)) {
                    FileInputStream input = new FileInputStream(this.filePath);
                    this.client.setFileType(2);
                    this.setResult(this.client.storeFile(this.filePath, (InputStream)input));
                    this.client.logout();
                }
            }
        }
        catch (SocketException ex) {
            Logger.getLogger(FTPUploadWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FTPUploadWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }
}

