/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.drools.compiler.kproject.KieModuleException;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.util.StringUtils;
import org.drools.xml.support.converters.AbstractXStreamConverter;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.RuleTemplateModel;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SessionsPoolOption;

public class KBaseConverter
extends AbstractXStreamConverter {
    public KBaseConverter() {
        super(KieBaseModelImpl.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        KieBaseModelImpl kBase = (KieBaseModelImpl)value;
        writer.addAttribute("name", kBase.getName());
        writer.addAttribute("default", Boolean.toString(kBase.isDefault()));
        if (kBase.getEventProcessingMode() != null) {
            writer.addAttribute("eventProcessingMode", kBase.getEventProcessingMode().getMode());
        }
        if (kBase.getEqualsBehavior() != null) {
            writer.addAttribute("equalsBehavior", kBase.getEqualsBehavior().toString().toLowerCase());
        }
        if (kBase.getMutability() != null) {
            writer.addAttribute("mutability", kBase.getMutability().toString().toLowerCase());
        }
        if (kBase.getDeclarativeAgenda() != null) {
            writer.addAttribute("declarativeAgenda", kBase.getDeclarativeAgenda().toString().toLowerCase());
        }
        if (kBase.getSequential() != null) {
            writer.addAttribute("sequential", kBase.getSequential() == SequentialOption.YES ? "true" : "false");
        }
        if (kBase.getSessionsPool() != null) {
            writer.addAttribute("sessionsPool", "" + kBase.getSessionsPool().getSize());
        }
        if (kBase.getBetaRangeIndexOption() != null) {
            writer.addAttribute("betaRangeIndex", kBase.getBetaRangeIndexOption().toString().toLowerCase());
        }
        if (kBase.getScope() != null) {
            writer.addAttribute("scope", kBase.getScope());
        }
        if (!kBase.getPackages().isEmpty()) {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (String pkg : kBase.getPackages()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(pkg);
            }
            writer.addAttribute("packages", buf.toString());
        }
        if (!kBase.getIncludes().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean insertComma = false;
            for (String include : kBase.getIncludes()) {
                if (insertComma) {
                    sb.append(", ");
                }
                sb.append(include);
                if (insertComma) continue;
                insertComma = true;
            }
            writer.addAttribute("includes", sb.toString());
        }
        for (RuleTemplateModel ruleTemplateModel : kBase.getRuleTemplates()) {
            this.writeObject(writer, context, "ruleTemplate", ruleTemplateModel);
        }
        for (KieSessionModel kSessionModel : kBase.getKieSessionModels().values()) {
            this.writeObject(writer, context, "ksession", kSessionModel);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String includes;
        String pkgs;
        String scope;
        String betaRangeIndex;
        String sessionsPool;
        String sequential;
        String declarativeAgenda;
        String mutability;
        String equalsBehavior;
        final KieBaseModelImpl kBase = new KieBaseModelImpl();
        String kbaseName = reader.getAttribute("name");
        if (kbaseName == null) {
            kbaseName = StringUtils.uuid();
        } else if (kbaseName.isEmpty()) {
            throw new KieModuleException("kbase name is empty in kmodule.xml");
        }
        kBase.setNameForUnmarshalling(kbaseName);
        kBase.setDefault("true".equals(reader.getAttribute("default")));
        String eventMode = reader.getAttribute("eventProcessingMode");
        if (eventMode != null) {
            kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
        }
        if ((equalsBehavior = reader.getAttribute("equalsBehavior")) != null) {
            kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior((String)equalsBehavior));
        }
        if ((mutability = reader.getAttribute("mutability")) != null) {
            kBase.setMutability(KieBaseMutabilityOption.determineMutability((String)mutability));
        }
        if ((declarativeAgenda = reader.getAttribute("declarativeAgenda")) != null) {
            kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda((String)declarativeAgenda));
        }
        if ((sequential = reader.getAttribute("sequential")) != null) {
            kBase.setSequential(SequentialOption.determineSequential((String)sequential));
        }
        if ((sessionsPool = reader.getAttribute("sessionsPool")) != null) {
            kBase.setSessionsPool(SessionsPoolOption.get((int)Integer.parseInt(sessionsPool)));
        }
        if ((betaRangeIndex = reader.getAttribute("betaRangeIndex")) != null) {
            kBase.setBetaRangeIndexOption(BetaRangeIndexOption.determineBetaRangeIndex((String)betaRangeIndex));
        }
        if ((scope = reader.getAttribute("scope")) != null) {
            kBase.setScope(scope.trim());
        }
        if ((pkgs = reader.getAttribute("packages")) != null) {
            for (String pkg : pkgs.split(",")) {
                kBase.addPackage(pkg.trim());
            }
        }
        if ((includes = reader.getAttribute("includes")) != null) {
            for (String include : includes.split(",")) {
                kBase.addInclude(include.trim());
            }
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            @Override
            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("ksession".equals(name)) {
                    KieSessionModelImpl kSession = KBaseConverter.this.readObject(reader, context, KieSessionModelImpl.class);
                    kBase.getRawKieSessionModels().put(kSession.getName(), kSession);
                    kSession.setKBase((KieBaseModel)kBase);
                } else if ("ruleTemplate".equals(name)) {
                    RuleTemplateModelImpl ruleTemplate = KBaseConverter.this.readObject(reader, context, RuleTemplateModelImpl.class);
                    kBase.getRawRuleTemplates().add(ruleTemplate);
                    ruleTemplate.setKBase((KieBaseModel)kBase);
                }
            }
        });
        return kBase;
    }
}

