/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import org.drools.model.Variable;
import org.drools.model.constraints.AbstractSingleConstraint;
import org.drools.model.functions.LambdaPrinter;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.PredicateN;
import org.drools.model.impl.ModelComponent;
import org.drools.model.view.Expr3ViewItemImpl;

public class SingleConstraint3<A, B, C>
extends AbstractSingleConstraint {
    private final Variable<A> var1;
    private final Variable<B> var2;
    private final Variable<C> var3;
    private final Predicate3<A, B, C> predicate;

    public SingleConstraint3(Variable<A> var1, Variable<B> var2, Variable<C> var3, Predicate3<A, B, C> predicate) {
        super(LambdaPrinter.print(predicate), predicate.predicateInformation());
        this.var1 = var1;
        this.var2 = var2;
        this.var3 = var3;
        this.predicate = predicate;
    }

    public SingleConstraint3(String exprId, Variable<A> var1, Variable<B> var2, Variable<C> var3, Predicate3<A, B, C> predicate) {
        super(exprId, predicate.predicateInformation());
        this.var1 = var1;
        this.var2 = var2;
        this.var3 = var3;
        this.predicate = predicate;
    }

    public SingleConstraint3(Expr3ViewItemImpl<A, B, C> expr) {
        this(expr.getExprId(), expr.getFirstVariable(), expr.getVar2(), expr.getVar3(), expr.getPredicate());
        this.setReactivitySpecs(expr.getReactivitySpecs());
    }

    @Override
    public Variable[] getVariables() {
        return new Variable[]{this.var1, this.var2, this.var3};
    }

    @Override
    public PredicateN getPredicate() {
        return objs -> this.predicate.test(objs[0], objs[1], objs[2]);
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleConstraint3 that = (SingleConstraint3)o;
        if (!ModelComponent.areEqualInModel(this.var1, that.var1)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.var2, that.var2)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.var3, that.var3)) {
            return false;
        }
        return this.predicate.equals(that.predicate);
    }

    @Override
    public SingleConstraint3<A, B, C> negate() {
        return this.negate(new SingleConstraint3<A, B, C>("!" + this.getExprId(), this.var1, this.var2, this.var3, this.predicate.negate()));
    }

    @Override
    public SingleConstraint3<A, B, C> replaceVariable(Variable oldVar, Variable newVar) {
        if (this.var1 == oldVar) {
            return new SingleConstraint3<A, B, C>(this.getExprId(), newVar, this.var2, this.var3, this.predicate);
        }
        if (this.var2 == oldVar) {
            return new SingleConstraint3<A, B, C>(this.getExprId(), this.var1, newVar, this.var3, this.predicate);
        }
        if (this.var3 == oldVar) {
            return new SingleConstraint3<A, B, C>(this.getExprId(), this.var1, this.var2, newVar, this.predicate);
        }
        return this;
    }
}

