/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.utils;

import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ViewUtils {
    public static final String GIT_REPO_VIEW_ID = "org.eclipse.egit.ui.RepositoriesView";
    public static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";

    private ViewUtils() {
    }

    public static boolean showServersView() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return false;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return false;
        }
        try {
            page.showView(SERVERS_VIEW_ID, null, 3);
            page.showView(SERVERS_VIEW_ID, null, 1);
            return true;
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)win.getShell(), (String)"Unable to Open View", (String)"An error occurred whilst trying to open the Servers View\nIs it possible the WST UI is not installed?");
            return false;
        }
    }

    public static void showGitRepositoriesView(Repository repository) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.showView(GIT_REPO_VIEW_ID, null, 3);
            IViewPart part = page.showView(GIT_REPO_VIEW_ID, null, 1);
            IWorkbenchPartSite site = part.getSite();
            RepositoryNode rn = new RepositoryNode(null, repository);
            TreePath tp = new TreePath(new Object[]{rn});
            TreeSelection ts = new TreeSelection(tp);
            site.getSelectionProvider().setSelection((ISelection)ts);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

