/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_3.xstream.DMNModelInstrumentedBaseConverter;
import org.kie.dmn.backend.marshalling.v1_3.xstream.MarshallingUtils;
import org.kie.dmn.model.api.Binding;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_3.TBinding;

public class BindingConverter
extends DMNModelInstrumentedBaseConverter {
    public static final String EXPRESSION = "expression";
    public static final String PARAMETER = "parameter";

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        Binding b = (Binding)parent;
        if (PARAMETER.equals(nodeName)) {
            b.setParameter((InformationItem)child);
        } else if (child instanceof Expression) {
            b.setExpression((Expression)child);
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        Binding b = (Binding)parent;
        this.writeChildrenNode(writer, context, b.getParameter(), PARAMETER);
        if (b.getExpression() != null) {
            this.writeChildrenNode(writer, context, b.getExpression(), MarshallingUtils.defineExpressionNodeName(b.getExpression()));
        }
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
    }

    public BindingConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new TBinding();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(TBinding.class);
    }
}

