/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.engine.DeploymentDetailView;
import org.jboss.bpm.console.client.engine.UpdateDeploymentDetailAction;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentListView
extends AbstractView {
    public static final String ID = DeploymentListView.class.getName();
    private Controller controller;
    private boolean initialized;
    private LayoutPanel deploymentList = null;
    private org.gwt.mosaic.ui.client.ListBox<DeploymentRef> listBox;
    private DeploymentRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<DeploymentRef> deployments = null;
    private DeploymentDetailView detailView;

    public DeploymentListView() {
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Deployments");
        this.setIcon(icons.deploymentIcon());
        this.listBox = this.createListBox();
    }

    private org.gwt.mosaic.ui.client.ListBox createListBox() {
        org.gwt.mosaic.ui.client.ListBox listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"ID", "Name", "Timestamp", "Suspended"});
        listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.deploymentList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.deploymentList.setPadding(0);
            this.deploymentList.setWidgetSpacing(0);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new ToolButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Delete", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            LayoutPanel filterPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            filterPanel.setStyleName("bpm-filter-panel");
            ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Suspended");
            dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            this.deploymentList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.deploymentList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.deploymentList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            this.detailView = new DeploymentDetailView();
            this.controller.addView(DeploymentDetailView.ID, (ViewInterface)this.detailView);
            layout.add((Widget)this.detailView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.initialized = true;
        }
    }

    public DeploymentRef getSelection() {
        DeploymentRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (DeploymentRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public void update(List<DeploymentRef> deployments) {
        this.deployments = deployments;
        this.renderFiltered();
    }

    private void renderFiltered() {
        if (this.deployments != null) {
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            model.clear();
            for (DeploymentRef dpl : this.deployments) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    model.add((Object)dpl);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (dpl.isSuspended() != showSuspended) continue;
                model.add((Object)dpl);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
            this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, null));
        }
    }

    public void select(String deploymentId) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        for (int i = 0; i < model.size(); ++i) {
            DeploymentRef ref = (DeploymentRef)model.get(i);
            if (!ref.getId().equals(deploymentId)) continue;
            this.listBox.setSelectedIndex(i);
            break;
        }
    }

    static /* synthetic */ SimpleDateFormat access$000(DeploymentListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ Controller access$100(DeploymentListView x0) {
        return x0.controller;
    }

    static /* synthetic */ int access$202(DeploymentListView x0, int x1) {
        x0.currentFilter = x1;
        return x0.currentFilter;
    }

    static /* synthetic */ int access$300(DeploymentListView x0) {
        return x0.FILTER_NONE;
    }

    static /* synthetic */ int access$400(DeploymentListView x0) {
        return x0.FILTER_ACTIVE;
    }

    static /* synthetic */ int access$500(DeploymentListView x0) {
        return x0.FILTER_SUSPENDED;
    }

    static /* synthetic */ void access$600(DeploymentListView x0) {
        x0.renderFiltered();
    }
}

