/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.engine.UpdateJobsAction;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobListView
extends AbstractView {
    public static final String ID = JobListView.class.getName();
    private Controller controller;
    private LayoutPanel jobList = null;
    private org.gwt.mosaic.ui.client.ListBox<JobRef> listBox;
    private JobRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_TIMER = 20;
    private int FILTER_MESSAGE = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<JobRef> jobs = null;
    private ApplicationContext appContext;

    public JobListView(ApplicationContext appContext) {
        this.setTitle("Jobs");
        this.appContext = appContext;
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setIcon(icons.jobsIcon());
        this.listBox = this.createListBox();
    }

    private org.gwt.mosaic.ui.client.ListBox createListBox() {
        org.gwt.mosaic.ui.client.ListBox listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"ID", "Due Date", "Type"});
        listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.jobList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.jobList.setPadding(0);
            this.jobList.setWidgetSpacing(0);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new ToolButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Execute", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            LayoutPanel filterPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            filterPanel.setStyleName("bpm-filter-panel");
            ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Timers");
            dropBox.addItem("Messages");
            dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            this.jobList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.jobList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.jobList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            this.controller.addAction(UpdateJobsAction.ID, (ActionInterface)new UpdateJobsAction());
            this.add((Widget)layout);
            this.initialized = true;
        }
    }

    public void update(List<JobRef> jobs) {
        this.jobs = jobs;
        this.renderFiltered();
    }

    private void renderFiltered() {
        if (this.jobs != null) {
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            model.clear();
            for (JobRef def : this.jobs) {
                if (this.FILTER_NONE == this.currentFilter) {
                    model.add((Object)def);
                    continue;
                }
                if (this.FILTER_TIMER == this.currentFilter && def.getType().equals("timer")) {
                    model.add((Object)def);
                    continue;
                }
                if (this.FILTER_MESSAGE != this.currentFilter || !def.getType().equals("message")) continue;
                model.add((Object)def);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
        }
    }

    public JobRef getSelection() {
        JobRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (JobRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    static /* synthetic */ SimpleDateFormat access$000(JobListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ Controller access$100(JobListView x0) {
        return x0.controller;
    }

    static /* synthetic */ int access$202(JobListView x0, int x1) {
        x0.currentFilter = x1;
        return x0.currentFilter;
    }

    static /* synthetic */ int access$300(JobListView x0) {
        return x0.FILTER_NONE;
    }

    static /* synthetic */ int access$400(JobListView x0) {
        return x0.FILTER_TIMER;
    }

    static /* synthetic */ int access$500(JobListView x0) {
        return x0.FILTER_MESSAGE;
    }

    static /* synthetic */ void access$600(JobListView x0) {
        x0.renderFiltered();
    }
}

