/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.process.InstanceDataView;
import org.jboss.bpm.console.client.process.LoadActivityDiagramAction;
import org.jboss.bpm.console.client.process.UpdateInstanceDataAction;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.bpm.console.client.util.WindowUtil;

public class InstanceDetailView
extends CaptionLayoutPanel
implements ViewInterface {
    public static final String ID = InstanceDetailView.class.getName();
    private Controller controller;
    private PropertyGrid grid;
    private ProcessInstanceRef currentInstance;
    private Button diagramBtn;
    private Button instanceDataBtn;
    private WindowPanel diagramWindowPanel;
    private WindowPanel instanceDataWindowPanel;
    private ApplicationContext appContext;
    private ActivityDiagramView diagramView;
    private InstanceDataView instanceDataView;
    private boolean hasDiagramPlugin;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ProcessDefinitionRef currentDefintion;

    public InstanceDetailView(ApplicationContext appContext) {
        super("Instance details");
        this.appContext = appContext;
        super.setStyleName("bpm-detail-panel");
        super.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        this.grid = new PropertyGrid(new String[]{"ID:", "Key:", "State", "Start Date:", "Activity:"});
        this.add((Widget)this.grid, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        LayoutPanel buttonPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.diagramBtn = new Button("Diagram", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.diagramBtn.setEnabled(false);
        buttonPanel.add((Widget)this.diagramBtn);
        this.instanceDataBtn = new Button("Instance Data", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceDataBtn.setEnabled(false);
        buttonPanel.add((Widget)this.instanceDataBtn);
        this.add((Widget)buttonPanel);
        this.hasDiagramPlugin = ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.GraphViewerPlugin");
    }

    private void createDiagramWindow(ProcessInstanceRef inst) {
        this.diagramWindowPanel = new WindowPanel("Process Instance Activity");
        this.diagramWindowPanel.setAnimationEnabled(true);
        this.diagramWindowPanel.setSize("320px", "240px");
        LayoutPanel layout = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        Label header = new Label("Instance: " + inst.getId());
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.diagramWindowPanel.addWindowCloseListener((WindowCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        layout.add((Widget)this.diagramView, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.diagramWindowPanel.setWidget((Widget)layout);
        WindowUtil.addMaximizeButton((WindowPanel)this.diagramWindowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        WindowUtil.addMinimizeButton((WindowPanel)this.diagramWindowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        this.diagramWindowPanel.center();
    }

    private void createDataWindow(ProcessInstanceRef inst) {
        this.instanceDataWindowPanel = new WindowPanel("Process Instance Data: " + inst.getId());
        this.instanceDataWindowPanel.setAnimationEnabled(true);
        this.instanceDataWindowPanel.setSize("320px", "240px");
        this.instanceDataWindowPanel.addWindowCloseListener((WindowCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceDataWindowPanel.addWindowResizeListener((WindowResizeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceDataWindowPanel.setWidget((Widget)this.instanceDataView);
        WindowUtil.addMaximizeButton((WindowPanel)this.instanceDataWindowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        WindowUtil.addMinimizeButton((WindowPanel)this.instanceDataWindowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        this.instanceDataWindowPanel.center();
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.diagramView = new ActivityDiagramView();
        this.instanceDataView = new InstanceDataView();
        controller.addView(ActivityDiagramView.ID, (ViewInterface)this.diagramView);
        controller.addView(InstanceDataView.ID, (ViewInterface)this.instanceDataView);
        controller.addAction(LoadActivityDiagramAction.ID, (ActionInterface)new LoadActivityDiagramAction());
        controller.addAction(UpdateInstanceDataAction.ID, (ActionInterface)new UpdateInstanceDataAction());
    }

    public void update(ProcessDefinitionRef def, ProcessInstanceRef instance) {
        this.currentDefintion = def;
        this.currentInstance = instance;
        String[] values = new String[]{instance.getId(), instance.getKey(), String.valueOf(instance.getState()), this.dateFormat.format(instance.getStartDate()), instance.getRootToken().getCurrentNodeName()};
        this.grid.update(values);
        if (this.hasDiagramPlugin) {
            this.diagramBtn.setEnabled(true);
        }
        this.instanceDataBtn.setEnabled(true);
    }

    public void clearView() {
        this.grid.clear();
        this.currentDefintion = null;
        this.currentInstance = null;
        this.diagramBtn.setEnabled(false);
        this.instanceDataBtn.setEnabled(false);
    }

    private ProcessDefinitionRef getCurrentDefintion() {
        return this.currentDefintion;
    }

    private ProcessInstanceRef getCurrentInstance() {
        return this.currentInstance;
    }

    static /* synthetic */ ProcessDefinitionRef access$000(InstanceDetailView x0) {
        return x0.getCurrentDefintion();
    }

    static /* synthetic */ ProcessInstanceRef access$100(InstanceDetailView x0) {
        return x0.getCurrentInstance();
    }

    static /* synthetic */ void access$200(InstanceDetailView x0, ProcessInstanceRef x1) {
        x0.createDiagramWindow(x1);
    }

    static /* synthetic */ Controller access$300(InstanceDetailView x0) {
        return x0.controller;
    }

    static /* synthetic */ ProcessInstanceRef access$400(InstanceDetailView x0) {
        return x0.currentInstance;
    }

    static /* synthetic */ void access$500(InstanceDetailView x0, ProcessInstanceRef x1) {
        x0.createDataWindow(x1);
    }

    static /* synthetic */ WindowPanel access$602(InstanceDetailView x0, WindowPanel x1) {
        x0.diagramWindowPanel = x1;
        return x0.diagramWindowPanel;
    }

    static /* synthetic */ WindowPanel access$702(InstanceDetailView x0, WindowPanel x1) {
        x0.instanceDataWindowPanel = x1;
        return x0.instanceDataWindowPanel;
    }

    static /* synthetic */ InstanceDataView access$800(InstanceDetailView x0) {
        return x0.instanceDataView;
    }
}

