/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.mvc4g.client.Controller;
import java.util.ArrayList;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.common.AbstractRESTAction;
import org.jboss.bpm.console.client.model.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.DiagramNodeInfo;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.process.events.ActivityDiagramResultEvent;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;

public class LoadActivityDiagramAction
extends AbstractRESTAction {
    public static final String ID = LoadActivityDiagramAction.class.getName();

    public String getId() {
        return ID;
    }

    public String getUrl(Object event) {
        ProcessInstanceRef inst = (ProcessInstanceRef)event;
        return URLBuilder.getInstance().getActiveNodeInfoURL(inst.getId());
    }

    public RequestBuilder.Method getRequestMethod() {
        return RequestBuilder.GET;
    }

    public void handleSuccessfulResponse(Controller controller, Object event, Response response) {
        ProcessInstanceRef inst = (ProcessInstanceRef)event;
        ConsoleLog.debug((String)("Parse: " + response.getText()));
        JSONValue root = JSONParser.parse((String)response.getText());
        if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            ArrayList<ActiveNodeInfo> activeNodeInfos = new ArrayList<ActiveNodeInfo>();
            for (int i = 0; i < array.size(); ++i) {
                JSONWalk walk = JSONWalk.on((JSONValue)array.get(i));
                JSONWalk.JSONWrapper wrapper = walk.next("activeNode");
                JSONObject activeNode = wrapper.asObject();
                int x = JSONWalk.on((JSONValue)activeNode).next("x").asInt();
                int y = JSONWalk.on((JSONValue)activeNode).next("y").asInt();
                int width = JSONWalk.on((JSONValue)activeNode).next("width").asInt();
                int height = JSONWalk.on((JSONValue)activeNode).next("height").asInt();
                String name = JSONWalk.on((JSONValue)activeNode).next("name").asString();
                activeNodeInfos.add(new ActiveNodeInfo(-1, -1, new DiagramNodeInfo(name, x, y, width, height)));
                wrapper = walk.next("activeNode");
            }
            ActivityDiagramView view = (ActivityDiagramView)controller.getView(ActivityDiagramView.ID);
            view.update(new ActivityDiagramResultEvent(URLBuilder.getInstance().getProcessImageURL(inst.getDefinitionId()), activeNodeInfos));
        }
    }
}

