/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.DeploymentPanel;

public class ProcessDetailView
extends CaptionLayoutPanel
implements ViewInterface {
    public static final String ID = ProcessDetailView.class.getName();
    private Controller controller;
    private PropertyGrid grid;
    private ProcessDefinitionRef currentProcess;
    private DeploymentPanel deploymentPanel;
    private boolean showDeployment;

    public ProcessDetailView() {
        super("Process details");
        super.setStyleName("bpm-detail-panel");
        this.grid = new PropertyGrid(new String[]{"ID:", "Key:", "Name:", "Suspended:", "Package:", "Description:"});
        DeckLayoutPanel deck = new DeckLayoutPanel();
        deck.add((Widget)this.grid);
        ListBox dropBox = new ListBox(false);
        dropBox.setStyleName("bpm-operation-ui");
        dropBox.addItem("Properties");
        if (ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.ProcessEnginePlugin")) {
            dropBox.addItem("Deployment");
            this.deploymentPanel = new DeploymentPanel();
            deck.add((Widget)this.deploymentPanel);
        }
        dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getHeader().add((Widget)dropBox, Caption.CaptionRegion.RIGHT);
        this.add((Widget)deck, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        deck.showWidget(dropBox.getSelectedIndex());
        this.add((Widget)deck, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
    }

    public void setController(Controller controller) {
        this.controller = controller;
        if (this.deploymentPanel != null) {
            this.deploymentPanel.setController(controller);
        }
    }

    public void update(ProcessDefinitionRef process) {
        this.currentProcess = process;
        String[] values = new String[]{process.getId(), process.getKey(), process.getName(), String.valueOf(process.isSuspended()), process.getPackageName(), process.getDescription()};
        this.grid.update(values);
        if (ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.ProcessEnginePlugin")) {
            this.deploymentPanel.update(process.getDeploymentId());
        }
    }

    public void clearView() {
        this.grid.clear();
        if (ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.ProcessEnginePlugin")) {
            this.deploymentPanel.clearView();
        }
        this.currentProcess = null;
    }
}

