/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl;

import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationInfo;
import org.jbpm.simulation.impl.SimulationEndNodeInstance;
import org.jbpm.simulation.impl.SimulationNodeInstance;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.SimulationStartNodeInstance;
import org.jbpm.simulation.impl.events.ProcessInstanceEndSimulationEvent;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.factory.CreateNewNodeFactory;
import org.jbpm.workflow.instance.impl.factory.ReuseNodeFactory;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;

public class SimulateProcessPathCommand
implements GenericCommand<Void> {
    private static final long serialVersionUID = 3485947845100224769L;
    private String processId;
    private SimulationContext simContext;
    private SimulationPath path;

    public SimulateProcessPathCommand(String processId, SimulationContext context, SimulationPath path) {
        this.processId = processId;
        this.simContext = context;
        this.path = path;
    }

    public Void execute(Context context) {
        NodeInstanceFactoryRegistry n = NodeInstanceFactoryRegistry.INSTANCE;
        n.register(RuleSetNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(Split.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(Join.class, (NodeInstanceFactory)new ReuseNodeFactory(SimulationNodeInstance.class));
        n.register(StartNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationStartNodeInstance.class));
        n.register(EndNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationEndNodeInstance.class));
        n.register(MilestoneNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(SubProcessNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(ActionNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(WorkItemNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(TimerNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(FaultNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(CompositeNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(CompositeContextNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(HumanTaskNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(ForEachNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(EventNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(StateNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(DynamicNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(CatchLinkNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        n.register(ThrowLinkNode.class, (NodeInstanceFactory)new CreateNewNodeFactory(SimulationNodeInstance.class));
        KieSession session = ((KnowledgeCommandContext)context).getKieSession();
        this.simContext.setClock((SessionPseudoClock)session.getSessionClock());
        this.simContext.setCurrentPath(this.path);
        SimulationInfo simInfo = this.simContext.getRepository().getSimulationInfo();
        if (simInfo != null) {
            simInfo.setProcessName(session.getKieBase().getProcess(this.processId).getName());
            simInfo.setProcessVersion(session.getKieBase().getProcess(this.processId).getVersion());
        }
        this.simContext.resetMaxEndTime();
        this.simContext.getExecutedNodes().clear();
        this.simContext.incrementProcessInstanceId();
        ProcessInstance pi = session.startProcess(this.processId);
        long instanceId = (long)session.getId() + pi.getId();
        this.simContext.getRepository().storeEvent(new ProcessInstanceEndSimulationEvent(this.processId, instanceId, this.simContext.getStartTime(), this.simContext.getMaxEndTime(), this.path.getPathId(), pi.getProcessName(), pi.getProcess().getVersion()));
        return null;
    }
}

