/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;

public class SimulationFilterPathFormatConverter
implements PathFormatConverter<List<SimulationPath>> {
    private SimulationDataProvider provider;

    public SimulationFilterPathFormatConverter() {
    }

    public SimulationFilterPathFormatConverter(SimulationDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public List<SimulationPath> convert(List<PathContext> paths) {
        ArrayList<SimulationPath> allPaths = new ArrayList<SimulationPath>();
        for (PathContext context : paths) {
            SimulationPath simPath = new SimulationPath();
            simPath.setPathId(context.getPathId());
            for (FlowElement fe : context.getPathElements()) {
                String ref;
                if (fe instanceof SequenceFlow) {
                    simPath.addSequenceFlow(fe.getId());
                    continue;
                }
                if (fe instanceof BoundaryEvent) {
                    simPath.addBoundaryEventId(fe.getId());
                    continue;
                }
                simPath.addActivity(fe.getId());
                if (!(fe instanceof ThrowEvent) || (ref = this.processEventDefinitions(((ThrowEvent)fe).getEventDefinitions())) == null) continue;
                simPath.addThrowEvent(fe.getId(), ref);
            }
            allPaths.add(simPath);
            if (this.provider == null) continue;
            this.provider.calculatePathProbability(simPath);
        }
        Collections.sort(allPaths, new Comparator<SimulationPath>(){

            @Override
            public int compare(SimulationPath o1, SimulationPath o2) {
                double difference = o1.getProbability() - o2.getProbability();
                if (difference > 0.0) {
                    return -1;
                }
                if (difference < 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        return allPaths;
    }

    protected String processEventDefinitions(List<EventDefinition> eventDefinitions) {
        String key = null;
        if (eventDefinitions != null) {
            for (EventDefinition edef : eventDefinitions) {
                if (edef instanceof SignalEventDefinition) {
                    key = ((SignalEventDefinition)edef).getSignalRef();
                } else if (edef instanceof MessageEventDefinition) {
                    key = "Message-" + ((MessageEventDefinition)edef).getMessageRef().getId();
                } else if (edef instanceof LinkEventDefinition) {
                    key = ((LinkEventDefinition)edef).getName();
                } else if (edef instanceof CompensateEventDefinition) {
                    key = ((CompensateEventDefinition)edef).getActivityRef().getId();
                } else if (edef instanceof ErrorEventDefinition) {
                    key = "Error-" + ((ErrorEventDefinition)edef).getErrorRef().getId();
                }
                if (key == null) continue;
                break;
            }
        }
        return key;
    }
}

