/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;

public class PathContextManager {
    private Stack<PathContext> paths = new Stack();
    private List<PathContext> completePaths = new ArrayList<PathContext>();
    protected Map<String, FlowElement> catchingEvents = null;

    public Map<String, FlowElement> getCatchingEvents() {
        return this.catchingEvents;
    }

    public void setCatchingEvents(Map<String, FlowElement> catchingEvents) {
        this.catchingEvents = catchingEvents;
    }

    public PathContext getContextFromStack() {
        if (this.paths.isEmpty()) {
            this.paths.push(new PathContext());
        }
        return this.paths.peek();
    }

    public void addToPath(FlowElement element, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.addPathElement(element);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() != PathContext.Type.ACTIVE) continue;
                ctx.addPathElement(element);
            }
        }
    }

    public void removeFromPath(FlowElement element, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.removePathElement(element);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() != PathContext.Type.ACTIVE) continue;
                ctx.removePathElement(element);
            }
        }
    }

    public void addAllToPath(List<SequenceFlow> elements, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.addAllPathElement(elements);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() != PathContext.Type.ACTIVE) continue;
                ctx.addAllPathElement(elements);
            }
        }
    }

    public PathContext cloneGiven(PathContext toclone) {
        PathContext clone = new PathContext(PathContext.Type.ACTIVE);
        clone.setCanBeFinishedNoIncrement(toclone.isCanBeFinished());
        clone.setCanBeFinishedCounter(toclone.getCanBeFinishedCounter());
        clone.setPathElements(new LinkedHashSet<FlowElement>(toclone.getPathElements()));
        clone.setVisitedSplitPoint(new LinkedHashSet<FlowElement>(toclone.getVisitedSplitPoint()));
        this.paths.push(clone);
        return clone;
    }

    public PathContext cloneGivenWithoutPush(PathContext toclone) {
        PathContext clone = new PathContext(PathContext.Type.ACTIVE);
        clone.setCanBeFinishedNoIncrement(toclone.isCanBeFinished());
        clone.setCanBeFinishedCounter(toclone.getCanBeFinishedCounter());
        clone.setPathElements(new LinkedHashSet<FlowElement>(toclone.getPathElements()));
        clone.setVisitedSplitPoint(new LinkedHashSet<FlowElement>(toclone.getVisitedSplitPoint()));
        toclone.setType(PathContext.Type.TEMP);
        return clone;
    }

    public Stack<PathContext> getPaths() {
        return this.paths;
    }

    public void finalizePath() {
        PathContext context = this.getContextFromStack();
        if (context.isCanBeFinished()) {
            PathContext completePath = this.paths.pop();
            completePath.setType(PathContext.Type.COMPLETED);
            this.addToCompleted(completePath);
        }
    }

    public void finalizePath(PathContext context) {
        if (context.isCanBeFinished()) {
            context.setType(PathContext.Type.COMPLETED);
            this.addToCompleted(context);
        }
    }

    public void clearCurrentContext() {
        this.paths.pop();
    }

    public void complete() {
        for (PathContext context : this.paths) {
            if (context.getType() == PathContext.Type.ROOT || context.getType() == PathContext.Type.TEMP) continue;
            this.addToCompleted(context);
        }
    }

    public List<PathContext> getCompletePaths() {
        return this.completePaths;
    }

    protected void addToCompleted(PathContext context) {
        StringBuffer pathIdElements = new StringBuffer();
        ArrayList<FlowElement> list = new ArrayList<FlowElement>(context.getPathElements());
        Collections.sort(list, new Comparator<FlowElement>(){

            @Override
            public int compare(FlowElement o1, FlowElement o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (FlowElement fe : list) {
            pathIdElements.append(fe.getId());
        }
        context.setPathId("Path" + pathIdElements.toString().hashCode() + "-" + this.completePaths.size());
        this.completePaths.add(context);
    }
}

