/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.UniformDistributionType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.util.BPMN2Utils;
import org.kie.api.definition.process.Node;

public class BPMN2SimulationDataProvider
implements SimulationDataProvider {
    private Definitions def;

    public BPMN2SimulationDataProvider(Definitions def) {
        this.def = def;
    }

    public BPMN2SimulationDataProvider(String bpmn2xml) {
        this.def = BPMN2Utils.getDefinitions(new ByteArrayInputStream(BPMN2SimulationDataProvider.getBytes(bpmn2xml)));
    }

    public BPMN2SimulationDataProvider(InputStream bpmn2Stream) {
        this.def = BPMN2Utils.getDefinitions(bpmn2Stream);
    }

    @Override
    public Map<String, Object> getSimulationDataForNode(Node node) {
        String nodeId = (String)node.getMetaData().get("UniqueId");
        return this.getSimulationDataForNode(nodeId);
    }

    public Map<String, Object> getSimulationDataForNode(String nodeId) {
        boolean reverse = false;
        if (nodeId.startsWith("$reverseprops$")) {
            reverse = true;
            nodeId = nodeId.replaceFirst("\\$reverseprops\\$", "");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        double defaultValue = 50.0;
        if (reverse) {
            defaultValue = 100.0 - defaultValue;
        }
        properties.put("probability", defaultValue);
        Scenario scenario = this.getDefaultScenario(this.def);
        if (scenario != null) {
            String baseTimeUnitValue = "";
            String baseCurrencyUnitValue = "";
            if (scenario.getScenarioParameters() != null) {
                baseCurrencyUnitValue = scenario.getScenarioParameters().getBaseCurrencyUnit();
                baseTimeUnitValue = scenario.getScenarioParameters().getBaseTimeUnit().getName();
            }
            if (scenario.getElementParameters() != null) {
                for (ElementParameters eleType : scenario.getElementParameters()) {
                    if (!eleType.getElementRef().equals(nodeId)) continue;
                    if (eleType.getControlParameters() != null && eleType.getControlParameters().getProbability() != null) {
                        FlowElement element = null;
                        for (RootElement root : this.def.getRootElements()) {
                            if (!(root instanceof Process)) continue;
                            element = this.findElementInContainer((FlowElementsContainer)root, nodeId);
                            if (element == null || !(element instanceof SequenceFlow)) break;
                            element = ((SequenceFlow)element).getSourceRef();
                            break;
                        }
                        if (element != null && element instanceof ParallelGateway) {
                            properties.put("probability", 100.0);
                        } else {
                            FloatingParameterType valType = (FloatingParameterType)eleType.getControlParameters().getProbability().getParameterValue().get(0);
                            double value = valType.getValue();
                            if (reverse) {
                                value = 100.0 - value;
                            }
                            properties.put("probability", value);
                        }
                    }
                    if (eleType.getTimeParameters() != null && eleType.getTimeParameters().getProcessingTime() != null) {
                        Parameter processingTime = eleType.getTimeParameters().getProcessingTime();
                        ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                        if (paramValue instanceof NormalDistributionType) {
                            NormalDistributionType ndt = (NormalDistributionType)paramValue;
                            properties.put("mean", ndt.getMean());
                            properties.put("standarddeviation", ndt.getStandardDeviation());
                            properties.put("distributiontype", "normal");
                        } else if (paramValue instanceof UniformDistributionType) {
                            UniformDistributionType udt = (UniformDistributionType)paramValue;
                            properties.put("max", udt.getMax());
                            properties.put("min", udt.getMin());
                            properties.put("distributiontype", "uniform");
                        } else if (paramValue instanceof PoissonDistributionType) {
                            PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                            properties.put("mean", pdt.getMean());
                            properties.put("distributiontype", "poisson");
                        }
                        properties.put("timeunit", baseTimeUnitValue);
                        if (eleType.getTimeParameters().getWaitTime() != null) {
                            FloatingParameterType waittimeType = (FloatingParameterType)eleType.getTimeParameters().getWaitTime().getParameterValue().get(0);
                            properties.put("waittime", waittimeType.getValue());
                        }
                    }
                    if (eleType.getCostParameters() != null) {
                        CostParameters costParams = eleType.getCostParameters();
                        if (costParams.getUnitCost() != null) {
                            FloatingParameterType unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0);
                            properties.put("unitcost", unitCostVal.getValue());
                        }
                        properties.put("currency", baseCurrencyUnitValue);
                    }
                    if (eleType.getResourceParameters() == null) continue;
                    ResourceParameters resourceParams = eleType.getResourceParameters();
                    if (resourceParams.getQuantity() != null) {
                        FloatingParameterType quantityVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0);
                        properties.put("quantity", quantityVal.getValue());
                    }
                    if (resourceParams.getAvailability() == null) continue;
                    FloatingParameterType workingHoursVal = (FloatingParameterType)resourceParams.getAvailability().getParameterValue().get(0);
                    properties.put("workinghours", workingHoursVal.getValue());
                }
            }
        }
        return properties;
    }

    protected FlowElement findElementInContainer(FlowElementsContainer container, String id) {
        List currentContainerElems = container.getFlowElements();
        for (FlowElement fElement : currentContainerElems) {
            FlowElement fe;
            if (fElement.getId().equals(id)) {
                return fElement;
            }
            if (!(fElement instanceof FlowElementsContainer) || (fe = this.findElementInContainer((FlowElementsContainer)fElement, id)) == null) continue;
            return fe;
        }
        return null;
    }

    @Override
    public double calculatePathProbability(SimulationPath path) {
        double probability = 100.0;
        LinkedHashSet<String> processedSourceElems = new LinkedHashSet<String>();
        for (String sequenceFlowId : path.getSequenceFlowsIds()) {
            double transitionProbability;
            String sourceElemId = path.getSeqenceFlowsSources().get(sequenceFlowId);
            if (processedSourceElems.contains(sourceElemId) || !((transitionProbability = ((Double)this.getSimulationDataForNode(sequenceFlowId).get("probability")).doubleValue()) > 0.0)) continue;
            probability *= transitionProbability / 100.0;
            processedSourceElems.add(sourceElemId);
        }
        for (String sequenceFlowId : path.getBoundaryEventIds()) {
            double transitionProbability = (Double)this.getSimulationDataForNode(sequenceFlowId).get("probability");
            if (!(transitionProbability > 0.0)) continue;
            probability *= transitionProbability / 100.0;
        }
        double result = probability / 100.0;
        path.setProbability(result);
        return result;
    }

    @Override
    public Map<String, Object> getProcessDataForNode(Node node) {
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
        FlowElement flowElement = null;
        List rootElements = this.def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            flowElement = this.findElementInContainer((FlowElementsContainer)root, (String)node.getMetaData().get("UniqueId"));
            break;
        }
        if (flowElement != null) {
            List defs;
            BoundaryEvent boundaryEvent;
            if (flowElement instanceof ScriptTask) {
                nodeProperties.put("node.type", "ScriptTask");
            } else if (flowElement instanceof BusinessRuleTask) {
                nodeProperties.put("node.type", "BusinessRuleTask");
            } else if (flowElement instanceof UserTask) {
                nodeProperties.put("node.type", "UserTask");
            } else if (flowElement instanceof SendTask) {
                nodeProperties.put("node.type", "SendTask");
            } else if (flowElement instanceof ServiceTask) {
                nodeProperties.put("node.type", "ServiceTask");
            } else if (flowElement instanceof ReceiveTask) {
                nodeProperties.put("node.type", "ReceiveTask");
            } else if (flowElement instanceof ManualTask) {
                nodeProperties.put("node.type", "ManualTask");
            } else if (flowElement instanceof InclusiveGateway) {
                nodeProperties.put("node.type", "InclusiveGateway");
            } else if (flowElement instanceof ExclusiveGateway) {
                nodeProperties.put("node.type", "ExclusiveGateway");
            } else if (flowElement instanceof ParallelGateway) {
                nodeProperties.put("node.type", "ParallelGateway");
            } else if (flowElement instanceof BoundaryEvent) {
                boundaryEvent = (BoundaryEvent)flowElement;
                defs = boundaryEvent.getEventDefinitions();
                String eventDef = "";
                if (defs != null && defs.size() > 0) {
                    eventDef = this.getEventDefinitionAsString((EventDefinition)defs.get(0));
                }
                nodeProperties.put("node.type", "BoundaryEvent:" + eventDef);
            } else if (flowElement instanceof IntermediateCatchEvent) {
                boundaryEvent = (IntermediateCatchEvent)flowElement;
                defs = boundaryEvent.getEventDefinitions();
                String eventDef = "";
                if (defs != null && defs.size() > 0) {
                    eventDef = this.getEventDefinitionAsString((EventDefinition)defs.get(0));
                }
                nodeProperties.put("node.type", "IntermediateCatchEvent:" + eventDef);
            } else if (flowElement instanceof IntermediateThrowEvent) {
                boundaryEvent = (IntermediateThrowEvent)flowElement;
                defs = boundaryEvent.getEventDefinitions();
                String eventDef = "";
                if (defs != null && defs.size() > 0) {
                    eventDef = this.getEventDefinitionAsString((EventDefinition)defs.get(0));
                }
                nodeProperties.put("node.type", "IntermediateThrowEvent:" + eventDef);
            } else if (flowElement instanceof StartEvent) {
                boundaryEvent = (StartEvent)flowElement;
                defs = boundaryEvent.getEventDefinitions();
                String eventDef = "";
                if (defs != null && defs.size() > 0) {
                    eventDef = this.getEventDefinitionAsString((EventDefinition)defs.get(0));
                }
                nodeProperties.put("node.type", "StartEvent:" + eventDef);
            } else if (flowElement instanceof EndEvent) {
                boundaryEvent = (EndEvent)flowElement;
                defs = boundaryEvent.getEventDefinitions();
                String eventDef = "";
                if (defs != null && defs.size() > 0) {
                    eventDef = this.getEventDefinitionAsString((EventDefinition)defs.get(0));
                }
                nodeProperties.put("node.type", "EndEvent:" + eventDef);
            }
        } else {
            nodeProperties.put("node.type", "unknown");
        }
        return nodeProperties;
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Scenario getDefaultScenario(Definitions def) {
        if (def.getRelationships() != null && def.getRelationships().size() > 0) {
            Relationship relationship = (Relationship)def.getRelationships().get(0);
            for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                BPSimDataType bpmsim;
                FeatureMap extensionElements = extattrval.getValue();
                List bpsimExtension = (List)extensionElements.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
                if (bpsimExtension == null || bpsimExtension.size() <= 0 || (bpmsim = (BPSimDataType)bpsimExtension.get(0)).getScenario() == null || bpmsim.getScenario().size() <= 0) continue;
                return (Scenario)bpmsim.getScenario().get(0);
            }
        }
        return null;
    }

    protected String getEventDefinitionAsString(EventDefinition eventDefinition) {
        if (eventDefinition instanceof SignalEventDefinition) {
            return "signalEventDefinition";
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            return "messageEventDefinition";
        }
        if (eventDefinition instanceof LinkEventDefinition) {
            return "linkEventDefinition";
        }
        if (eventDefinition instanceof CompensateEventDefinition) {
            return "compensateEventDefinition";
        }
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "errorEventDefinition";
        }
        if (eventDefinition instanceof TimerEventDefinition) {
            return "timerEventDefinition";
        }
        if (eventDefinition instanceof ConditionalEventDefinition) {
            return "conditionalEventDefinition";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "cancelEventDefinition";
        }
        return "unknown";
    }
}

