/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.simulation.AggregatedSimulationEvent;
import org.jbpm.simulation.SimulationEvent;
import org.jbpm.simulation.impl.InMemorySimulationRepository;
import org.jbpm.simulation.impl.SystemOutLogger;
import org.jbpm.simulation.impl.events.AggregatedProcessSimulationEvent;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class WorkingMemorySimulationRepository
extends InMemorySimulationRepository {
    private KieSession ksession;
    private boolean fireRulesOnStore = false;

    public WorkingMemorySimulationRepository() {
    }

    public WorkingMemorySimulationRepository(String ... rules) {
        this(false, rules);
    }

    public WorkingMemorySimulationRepository(Resource ... rules) {
        this(false, rules);
    }

    public WorkingMemorySimulationRepository(boolean fireRulesOnStore, Resource ... rules) {
        this.fireRulesOnStore = fireRulesOnStore;
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (Resource path : rules) {
            kbuilder.add(path, ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Error while building knowledge base: " + kbuilder.getErrors());
        }
        this.ksession = kbuilder.newKnowledgeBase().newKieSession();
        try {
            this.ksession.setGlobal("logger", (Object)new SystemOutLogger());
            this.ksession.setGlobal("simulation", new ArrayList());
            this.ksession.setGlobal("summary", new ArrayList());
            AggregatedProcessSimulationEvent init = new AggregatedProcessSimulationEvent("", 0.0, 0.0, 0.0);
            ArrayList<AggregatedProcessSimulationEvent> processOnlyList = new ArrayList<AggregatedProcessSimulationEvent>();
            processOnlyList.add(init);
            this.ksession.setGlobal("processEventsOnly", processOnlyList);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public WorkingMemorySimulationRepository(boolean fireRulesOnStore, String ... rules) {
        this.fireRulesOnStore = fireRulesOnStore;
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String path : rules) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)path), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Error while building knowledge base: " + kbuilder.getErrors());
        }
        this.ksession = kbuilder.newKnowledgeBase().newKieSession();
        try {
            this.ksession.setGlobal("logger", (Object)new SystemOutLogger());
            this.ksession.setGlobal("simulation", new ArrayList());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void storeEvent(SimulationEvent event) {
        super.storeEvent(event);
        this.ksession.insert((Object)event);
        if (this.fireRulesOnStore) {
            this.ksession.fireAllRules();
        }
    }

    public void fireAllRules() {
        this.ksession.fireAllRules();
    }

    public KieSession getSession() {
        return this.ksession;
    }

    public List<AggregatedSimulationEvent> getAggregatedEvents() {
        return (List)this.ksession.getGlobal("simulation");
    }

    public Object getGlobal(String globalName) {
        return this.ksession.getGlobal(globalName);
    }

    @Override
    public void close() {
        super.close();
        this.ksession.dispose();
    }
}

