/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jbpm.simulation.impl.ht.AllocatedWork;

public class AllocatedResources {
    private int poolSize;
    private long performedWork = 0L;
    private List<Long> allocatedTill = new ArrayList<Long>();

    public AllocatedResources(int poolSize) {
        this.poolSize = poolSize;
    }

    public AllocatedWork allocate(long startTime, long duration, long limit) {
        long waitTime = 0L;
        AllocatedWork allocatedWork = new AllocatedWork(duration);
        this.performedWork += duration;
        if (this.poolSize == 0) {
            allocatedWork.setAllocatedTime(startTime + duration);
            allocatedWork.setWaitTime(duration);
            return allocatedWork;
        }
        if (this.allocatedTill.size() < this.poolSize) {
            long allocated = startTime + duration;
            if (allocated > limit) {
                allocated = limit;
            }
            this.allocatedTill.add(allocated);
            allocatedWork.setAllocatedTime(allocated - startTime);
            allocatedWork.setWaitTime(waitTime);
        } else {
            Collections.sort(this.allocatedTill);
            long allocated = this.allocatedTill.get(0);
            if (allocated == limit) {
                waitTime = allocated - startTime;
                allocatedWork.setAllocatedTime(0L);
                allocatedWork.setWaitTime(waitTime);
                return allocatedWork;
            }
            if (allocated >= startTime) {
                waitTime = allocated - startTime;
                allocated += duration;
            } else {
                allocated = startTime + duration;
            }
            if (allocated > limit) {
                this.allocatedTill.set(0, limit);
                allocatedWork.setAllocatedTime(duration - (allocated - limit));
                allocatedWork.setWaitTime(waitTime);
            } else {
                this.allocatedTill.set(0, allocated);
                allocatedWork.setAllocatedTime(allocated - startTime);
                allocatedWork.setWaitTime(waitTime);
            }
        }
        return allocatedWork;
    }
}

