/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.SubProcess;
import org.jbpm.simulation.handler.ActivityElementHandler;
import org.jbpm.simulation.handler.AdHocSubProcessElementHandler;
import org.jbpm.simulation.handler.ConvergingGatewayElementHandler;
import org.jbpm.simulation.handler.DefaultElementHandler;
import org.jbpm.simulation.handler.ElementHandler;
import org.jbpm.simulation.handler.EmbeddedSubprocessHandler;
import org.jbpm.simulation.handler.EventElementHandler;
import org.jbpm.simulation.handler.GatewayElementHandler;
import org.jbpm.simulation.handler.MainElementHandler;
import org.jbpm.simulation.handler.ThrowEventElementHandler;

public class HandlerRegistry {
    public static ElementHandler getHandler(Object flowElement) {
        if (flowElement instanceof Gateway) {
            if (((Gateway)flowElement).getGatewayDirection() == GatewayDirection.CONVERGING) {
                return new ConvergingGatewayElementHandler();
            }
            return new GatewayElementHandler();
        }
        if (flowElement instanceof AdHocSubProcess) {
            return new AdHocSubProcessElementHandler();
        }
        if (flowElement instanceof SubProcess) {
            return new EmbeddedSubprocessHandler();
        }
        if (flowElement instanceof Activity) {
            return new ActivityElementHandler();
        }
        if (flowElement instanceof IntermediateThrowEvent) {
            return new ThrowEventElementHandler();
        }
        if (flowElement instanceof EndEvent) {
            return new EventElementHandler();
        }
        return null;
    }

    public static ElementHandler getHandler() {
        return new DefaultElementHandler();
    }

    public static ElementHandler getMainHandler() {
        return new MainElementHandler();
    }
}

