/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.DefaultElementHandler;

public class ThrowEventElementHandler
extends DefaultElementHandler {
    @Override
    public boolean handle(FlowElement element, PathContextManager manager) {
        List<EventDefinition> throwDefinitions = this.getEventDefinitions(element);
        if (throwDefinitions != null && throwDefinitions.size() > 0) {
            for (EventDefinition def : throwDefinitions) {
                FlowElement catchEvent;
                String key = "";
                if (def instanceof SignalEventDefinition) {
                    key = ((SignalEventDefinition)def).getSignalRef();
                } else if (def instanceof MessageEventDefinition) {
                    key = ((MessageEventDefinition)def).getMessageRef().getId();
                } else if (def instanceof LinkEventDefinition) {
                    key = ((LinkEventDefinition)def).getName();
                } else if (def instanceof CompensateEventDefinition) {
                    key = ((CompensateEventDefinition)def).getActivityRef().getId();
                } else if (def instanceof ErrorEventDefinition) {
                    key = ((ErrorEventDefinition)def).getErrorRef().getId();
                }
                if ((catchEvent = manager.getCatchingEvents().get(key)) == null || !this.hasPathToCatchEvent(catchEvent)) continue;
                PathContext context = manager.getContextFromStack();
                boolean canBeFinished = context.isCanBeFinished();
                context.setCanBeFinishedNoIncrement(false);
                super.handle(catchEvent, manager);
                context.setCanBeFinishedNoIncrement(canBeFinished);
            }
        }
        return super.handle(element, manager);
    }

    protected boolean hasPathToCatchEvent(FlowElement catchEvent) {
        List incoming = ((CatchEvent)catchEvent).getIncoming();
        boolean hasSplitActivity = this.findSplitActivity(incoming);
        return !hasSplitActivity;
    }

    protected boolean findSplitActivity(List<SequenceFlow> incoming) {
        if (incoming == null) {
            return false;
        }
        for (SequenceFlow sq : incoming) {
            FlowNode source = sq.getSourceRef();
            if ((source instanceof ExclusiveGateway || source instanceof InclusiveGateway) && ((Gateway)source).getGatewayDirection().equals((Object)GatewayDirection.DIVERGING)) {
                return true;
            }
            boolean found = this.findSplitActivity(source.getIncoming());
            if (!found) continue;
            return found;
        }
        return false;
    }
}

