/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.Calendar;
import org.jbpm.simulation.impl.ht.AllocatedResources;
import org.jbpm.simulation.impl.ht.AllocatedWork;
import org.joda.time.Interval;

public class Range
implements Comparable<Range> {
    private int start;
    private int end;
    private Calendar localCalendar;
    private Interval interval;
    private AllocatedResources resources;

    public Range(int start, int end, int resourcePoolSize) {
        this.start = start;
        this.end = end;
        this.resources = new AllocatedResources(resourcePoolSize);
        this.localCalendar = Calendar.getInstance();
    }

    public boolean contains(long time) {
        this.localCalendar.setTimeInMillis(time);
        this.localCalendar.set(11, this.start);
        this.localCalendar.set(12, 0);
        long startInstant = this.localCalendar.getTimeInMillis();
        this.localCalendar.set(11, this.end);
        long endInstant = this.localCalendar.getTimeInMillis();
        this.interval = new Interval(startInstant, endInstant);
        return this.interval.contains(time);
    }

    public AllocatedWork allocate(long startTime, long duration) {
        AllocatedWork allocatedWork = this.resources.allocate(startTime, duration, this.interval.getEndMillis());
        return allocatedWork;
    }

    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public int compareTo(Range o) {
        return this.end - o.start;
    }
}

