/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.simulation.AggregatedSimulationEvent;

public class AggregatedProcessSimulationEvent
implements AggregatedSimulationEvent {
    protected String type;
    protected String processId;
    protected String processName;
    protected String processVersion;
    protected double minExecutionTime;
    protected double avgExecutionTime;
    protected double maxExecutionTime;
    protected Map<String, Integer> pathInstances = new HashMap<String, Integer>();

    public AggregatedProcessSimulationEvent(Object processInfo, Number minExecutionTime, Number avgExecutionTime, Number maxExecutionTime) {
        this.setProcessInfoValues(processInfo);
        this.minExecutionTime = minExecutionTime.doubleValue();
        this.avgExecutionTime = avgExecutionTime.doubleValue();
        this.maxExecutionTime = maxExecutionTime.doubleValue();
        this.type = "process";
    }

    protected void setProcessInfoValues(Object processInfo) {
        if (processInfo instanceof Set && !((Set)processInfo).isEmpty()) {
            String values = (String)((Set)processInfo).toArray()[0];
            String[] splitValues = values.split("@");
            if (splitValues.length > 0) {
                this.processId = splitValues[0];
            }
            if (splitValues.length > 1) {
                this.processName = splitValues[1];
            }
            if (splitValues.length > 2) {
                this.processVersion = splitValues[2];
            }
        }
    }

    public double getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public void setMinExecutionTime(double minExecutionTime) {
        this.minExecutionTime = minExecutionTime;
    }

    public double getAvgExecutionTime() {
        return this.avgExecutionTime;
    }

    public void setAvgExecutionTime(double avgExecutionTime) {
        this.avgExecutionTime = avgExecutionTime;
    }

    public double getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(double maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    @Override
    public Object getProperty(String name) {
        if ("minExecutionTime".equalsIgnoreCase(name)) {
            return this.minExecutionTime;
        }
        if ("avgExecutionTime".equalsIgnoreCase(name)) {
            return this.avgExecutionTime;
        }
        if ("maxExecutionTime".equalsIgnoreCase(name)) {
            return this.maxExecutionTime;
        }
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    public void calculatePaths(List<String> pathIds) {
        for (String pathId : pathIds) {
            Integer current = this.pathInstances.get(pathId);
            if (current == null) {
                current = 1;
            } else {
                Integer n = current;
                Integer n2 = current = Integer.valueOf(current + 1);
            }
            this.pathInstances.put(pathId, current);
        }
    }

    public void calculateAggregatedPaths(List<String> pathIds) {
        for (String pathInfo : pathIds) {
            String[] entires;
            for (String entry : entires = pathInfo.split(";")) {
                String[] keyValue = entry.split("=");
                int current = 0;
                int nextValue = Integer.valueOf(keyValue[1]);
                if (this.pathInstances.containsKey(keyValue[0])) {
                    current = this.pathInstances.get(keyValue[0]);
                }
                if (current >= nextValue) continue;
                this.pathInstances.put(keyValue[0], nextValue);
            }
        }
    }

    public String getPathInfo() {
        StringBuffer info = new StringBuffer();
        for (Map.Entry<String, Integer> entries : this.pathInstances.entrySet()) {
            info.append(entries.getKey() + "=" + entries.getValue() + ";");
        }
        info.deleteCharAt(info.length() - 1);
        return info.toString();
    }

    public Map<String, Integer> getPathNumberOfInstances() {
        return this.pathInstances;
    }

    public Integer getNumberOfInstancesPerPath(String pathId) {
        return this.pathInstances.get(pathId);
    }
}

