/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;

public class SimulationFilterPathFormatConverter
implements PathFormatConverter<List<SimulationPath>> {
    private SimulationDataProvider provider;

    public SimulationFilterPathFormatConverter() {
    }

    public SimulationFilterPathFormatConverter(SimulationDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public List<SimulationPath> convert(List<PathContext> paths) {
        ArrayList<SimulationPath> allPaths = new ArrayList<SimulationPath>();
        for (PathContext context : paths) {
            SimulationPath simPath = new SimulationPath();
            simPath.setPathId(context.getPathId());
            for (FlowElement fe : context.getPathElements()) {
                if (fe instanceof SequenceFlow) {
                    simPath.addSequenceFlow(fe.getId());
                    simPath.addSequenceFlowSource(fe.getId(), ((SequenceFlow)fe).getSourceRef().getId());
                } else if (this.isGatewaySplit(fe)) {
                    if (this.provider != null) {
                        double probability = 0.0;
                        for (SequenceFlow sq : ((Gateway)fe).getOutgoing()) {
                            if (!(this.provider instanceof BPMN2SimulationDataProvider)) continue;
                            probability += ((Double)((BPMN2SimulationDataProvider)this.provider).getSimulationDataForNode(sq.getId()).get("probability")).doubleValue();
                        }
                        BigDecimal bd = new BigDecimal(probability);
                        probability = (bd = bd.setScale(5, 4)).doubleValue();
                        if (probability != 100.0) {
                            throw new IllegalArgumentException("Process is not valid for simulation - use validation to find errors");
                        }
                    }
                } else if (fe instanceof BoundaryEvent) {
                    simPath.addBoundaryEventId(fe.getId());
                } else if (fe instanceof CatchEvent) {
                    CatchEvent act = (CatchEvent)fe;
                    if (act.getIncoming() == null || act.getIncoming().isEmpty() && !this.isParentEventSubprocess(fe)) {
                        String ref = this.processEventDefinitions(((CatchEvent)fe).getEventDefinitions());
                        simPath.setSignalName(ref);
                    }
                } else {
                    String ref;
                    simPath.addActivity(fe.getId());
                    if (fe instanceof ThrowEvent && (ref = this.processEventDefinitions(((ThrowEvent)fe).getEventDefinitions())) != null) {
                        simPath.addThrowEvent(fe.getId(), ref);
                    }
                }
                if (!(fe instanceof StartEvent) || this.isParentEventSubprocess(fe)) continue;
                simPath.setStartable(true);
            }
            allPaths.add(simPath);
            if (this.provider == null) continue;
            this.provider.calculatePathProbability(simPath);
        }
        Collections.sort(allPaths, new Comparator<SimulationPath>(){

            @Override
            public int compare(SimulationPath o1, SimulationPath o2) {
                double difference = o1.getProbability() - o2.getProbability();
                if (difference > 0.0) {
                    return -1;
                }
                if (difference < 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        return allPaths;
    }

    private boolean isParentEventSubprocess(FlowElement fe) {
        return fe.eContainer() instanceof SubProcess && ((SubProcess)fe.eContainer()).isTriggeredByEvent();
    }

    protected String processEventDefinitions(List<EventDefinition> eventDefinitions) {
        String key = null;
        if (eventDefinitions != null) {
            for (EventDefinition edef : eventDefinitions) {
                if (edef instanceof SignalEventDefinition) {
                    key = ((SignalEventDefinition)edef).getSignalRef();
                } else if (edef instanceof MessageEventDefinition) {
                    key = "Message-" + ((MessageEventDefinition)edef).getMessageRef().getId();
                } else if (edef instanceof LinkEventDefinition) {
                    key = ((LinkEventDefinition)edef).getName();
                } else if (edef instanceof CompensateEventDefinition) {
                    key = ((CompensateEventDefinition)edef).getActivityRef().getId();
                } else if (edef instanceof ErrorEventDefinition) {
                    key = "Error-" + ((ErrorEventDefinition)edef).getErrorRef().getId();
                }
                if (key == null) continue;
                break;
            }
        }
        return key;
    }

    private boolean isGatewaySplit(FlowElement fe) {
        return (fe instanceof ExclusiveGateway || fe instanceof InclusiveGateway || fe instanceof EventBasedGateway) && ((Gateway)fe).getGatewayDirection().equals((Object)GatewayDirection.DIVERGING);
    }
}

