/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.pmml_4_2.descr.DataDictionary;
import org.dmg.pmml.pmml_4_2.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_2.descr.MiningField;
import org.dmg.pmml.pmml_4_2.descr.MiningSchema;
import org.dmg.pmml.pmml_4_2.descr.Output;
import org.dmg.pmml.pmml_4_2.descr.OutputField;
import org.kie.pmml.pmml_4_2.PMML4Helper;
import org.kie.pmml.pmml_4_2.PMML4Model;
import org.kie.pmml.pmml_4_2.PMML4Unit;
import org.kie.pmml.pmml_4_2.model.Miningmodel;
import org.kie.pmml.pmml_4_2.model.PMML4ModelType;
import org.kie.pmml.pmml_4_2.model.PMMLDataField;
import org.kie.pmml.pmml_4_2.model.PMMLMiningField;
import org.kie.pmml.pmml_4_2.model.PMMLOutputField;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateError;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.templates.TemplateRuntimeError;

public abstract class AbstractModel<T>
implements PMML4Model {
    private String modelId;
    private PMML4ModelType modelType;
    private PMML4Unit owner;
    private PMML4Model parentModel;
    protected T rawModel;
    protected Map<String, MiningField> miningFieldMap;
    protected Map<String, OutputField> outputFieldMap;
    private static Map<String, Integer> generatedModelIds;
    protected static PMML4Helper helper;
    protected static final String MINING_TEMPLATE_NAME = "MiningSchemaPOJOTemplate";
    protected static final String OUTPUT_TEMPLATE_NAME = "OutputPOJOTemplate";
    protected static TemplateRegistry templateRegistry;
    public static final String PMML_JAVA_PACKAGE_NAME = "org.kie.pmml.pmml_4_2.model";

    protected abstract void addMiningTemplateToRegistry(TemplateRegistry var1);

    protected abstract void addOutputTemplateToRegistry(TemplateRegistry var1);

    public AbstractModel(String modelId, PMML4ModelType modelType, PMML4Unit owner, T rawModel) {
        this.modelId = modelId;
        this.modelType = modelType;
        this.owner = owner;
        this.rawModel = rawModel;
        this.parentModel = null;
        this.initFieldMaps();
    }

    public AbstractModel(String modelId, PMML4ModelType modelType, PMML4Unit owner, PMML4Model parentModel, T rawModel) {
        this.modelId = modelId;
        this.modelType = modelType;
        this.owner = owner;
        this.rawModel = rawModel;
        this.parentModel = parentModel;
        this.initFieldMaps();
    }

    protected void initFieldMaps() {
        this.initMiningFieldMap();
        this.initOutputFieldMap();
    }

    protected void initMiningFieldMap() {
        MiningSchema schema = this.getMiningSchema();
        this.miningFieldMap = new HashMap<String, MiningField>();
        for (MiningField field : schema.getMiningFields()) {
            this.miningFieldMap.put(field.getName(), field);
        }
    }

    protected void initOutputFieldMap() {
        Output output = this.getOutput();
        this.outputFieldMap = new HashMap<String, OutputField>();
        if (output != null) {
            for (OutputField field : output.getOutputFields()) {
                this.outputFieldMap.put(field.getName(), field);
            }
        }
    }

    protected MiningField getValidMiningField(PMMLDataField dataField) {
        if (this.miningFieldMap.containsKey(dataField.getName())) {
            return this.miningFieldMap.get(dataField.getName());
        }
        return null;
    }

    protected String getMiningPojoTemplateName() {
        return this.modelType.toString() + "_" + MINING_TEMPLATE_NAME;
    }

    protected String getOutputPojoTemplateName() {
        return this.modelType.toString() + "_" + OUTPUT_TEMPLATE_NAME;
    }

    @Override
    public Map.Entry<String, String> getMappedMiningPojo() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!templateRegistry.contains(this.getMiningPojoTemplateName())) {
            this.addMiningTemplateToRegistry(templateRegistry);
        }
        List<PMMLMiningField> dataFields = this.getMiningFields();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        String className = this.getMiningPojoClassName();
        vars.put("pmmlPackageName", PMML_JAVA_PACKAGE_NAME);
        vars.put("className", className);
        vars.put("imports", new ArrayList());
        vars.put("dataFields", dataFields);
        vars.put("modelName", this.getModelId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TemplateRuntime.execute((CompiledTemplate)templateRegistry.getNamedTemplate(this.getMiningPojoTemplateName()), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (OutputStream)baos);
        }
        catch (TemplateRuntimeError tre) {
            return null;
        }
        result.put(className, new String(baos.toByteArray()));
        return result.entrySet().iterator().next();
    }

    @Override
    public Map.Entry<String, String> getMappedOutputPojo() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!templateRegistry.contains(this.getOutputPojoTemplateName())) {
            this.addOutputTemplateToRegistry(templateRegistry);
        }
        List<PMMLOutputField> dataFields = this.getOutputFields();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        String className = this.getOutputPojoClassName();
        vars.put("pmmlPackageName", PMML_JAVA_PACKAGE_NAME);
        vars.put("className", className);
        vars.put("imports", new ArrayList());
        vars.put("dataFields", dataFields);
        vars.put("modelName", this.getModelId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TemplateRuntime.execute((CompiledTemplate)templateRegistry.getNamedTemplate(this.getOutputPojoTemplateName()), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (OutputStream)baos);
        }
        catch (TemplateError te) {
            return null;
        }
        catch (TemplateRuntimeError tre) {
            return null;
        }
        result.put(className, new String(baos.toByteArray()));
        return result.entrySet().iterator().next();
    }

    @Override
    public List<PMMLMiningField> getMiningFields() {
        ArrayList<PMMLMiningField> fields = new ArrayList<PMMLMiningField>();
        Map<String, MiningField> excludesTargetMap = this.getFilteredMiningFieldMap(false, FIELDUSAGETYPE.TARGET);
        Map<String, PMMLDataField> dataDictionary = this.getOwner().getDataDictionaryMap();
        for (String key : excludesTargetMap.keySet()) {
            PMML4Model ultimateParentModel;
            PMMLDataField df = dataDictionary.get(key);
            MiningField mf = this.miningFieldMap.get(key);
            if (df != null) {
                fields.add(new PMMLMiningField(mf, df.getRawDataField(), this.getModelId(), true));
                continue;
            }
            PMMLMiningField fld = new PMMLMiningField(mf, this.getModelId());
            if (this.getParentModel() == null || !((ultimateParentModel = this.getParentModel()) instanceof Miningmodel)) continue;
            while (ultimateParentModel.getParentModel() != null) {
                ultimateParentModel = ultimateParentModel.getParentModel();
            }
            PMMLOutputField ofld = ((Miningmodel)ultimateParentModel).findOutputField(fld.getName());
            if (ofld == null) continue;
            fld.setType(ofld.getType());
            fields.add(fld);
        }
        return fields;
    }

    public PMMLOutputField findOutputField(String fieldName) {
        return null;
    }

    @Override
    public List<PMMLOutputField> getOutputFields() {
        ArrayList<PMMLOutputField> fields = new ArrayList<PMMLOutputField>();
        for (String key : this.outputFieldMap.keySet()) {
            OutputField of = this.outputFieldMap.get(key);
            fields.add(new PMMLOutputField(of, null, this.getModelId()));
        }
        Map<String, MiningField> includeFromMining = this.getFilteredMiningFieldMap(true, FIELDUSAGETYPE.PREDICTED, FIELDUSAGETYPE.TARGET);
        Map<String, PMMLDataField> dataDictionary = this.getOwner().getDataDictionaryMap();
        if (includeFromMining != null && !includeFromMining.isEmpty()) {
            for (String key : includeFromMining.keySet()) {
                MiningField field = includeFromMining.get(key);
                PMMLDataField df = dataDictionary.get(key);
                fields.add(new PMMLOutputField(field, df.getRawDataField(), this.getModelId()));
            }
        }
        return fields;
    }

    @Override
    public PMML4ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public String getModelId() {
        if (this.modelId == null) {
            this.modelId = this.generateModelId();
        }
        return this.modelId;
    }

    @Override
    public PMML4Unit getOwner() {
        PMML4Model parent;
        PMML4Unit ownedBy = this.owner;
        if (ownedBy == null && (parent = this.getParentModel()) != null) {
            ownedBy = parent.getOwner();
        }
        return ownedBy;
    }

    @Override
    public List<MiningField> getRawMiningFields() {
        return this.miningFieldMap != null && !this.miningFieldMap.isEmpty() ? new ArrayList<MiningField>(this.miningFieldMap.values()) : new ArrayList<MiningField>();
    }

    @Override
    public List<OutputField> getRawOutputFields() {
        return this.outputFieldMap != null && !this.outputFieldMap.isEmpty() ? new ArrayList<OutputField>(this.outputFieldMap.values()) : new ArrayList<OutputField>();
    }

    @Override
    public Map<String, PMML4Model> getChildModels() {
        return new HashMap<String, PMML4Model>();
    }

    @Override
    public PMML4Model getParentModel() {
        return this.parentModel;
    }

    @Override
    public void setParentModel(PMML4Model parentModel) {
        this.parentModel = parentModel;
    }

    public Map<String, MiningField> getMiningFieldMap() {
        return new HashMap<String, MiningField>(this.miningFieldMap);
    }

    public Map<String, MiningField> getFilteredMiningFieldMap(boolean includeFiltered, FIELDUSAGETYPE ... filterTypes) {
        HashMap<String, MiningField> mfm = new HashMap<String, MiningField>();
        List<FIELDUSAGETYPE> filteredTypes = Arrays.asList(filterTypes);
        for (String key : this.miningFieldMap.keySet()) {
            MiningField field = this.miningFieldMap.get(key);
            FIELDUSAGETYPE usageType = field.getUsageType();
            if ((!includeFiltered || !filteredTypes.contains((Object)usageType)) && (includeFiltered || filteredTypes.contains((Object)usageType))) continue;
            mfm.put(key, field);
        }
        return mfm;
    }

    public List<PMMLMiningField> getActiveMiningFields() {
        ArrayList<PMMLMiningField> activeMiningFields = new ArrayList<PMMLMiningField>();
        List<PMMLMiningField> allMiningFields = this.getMiningFields();
        for (PMMLMiningField field : allMiningFields) {
            if (field.getFieldUsageType() != FIELDUSAGETYPE.ACTIVE) continue;
            activeMiningFields.add(field);
        }
        return activeMiningFields;
    }

    private String generateModelId() {
        String mt = this.modelType.toString();
        StringBuilder mid = new StringBuilder(mt);
        Integer lastId = null;
        lastId = generatedModelIds.containsKey(mt) ? generatedModelIds.get(mt) : new Integer(-1);
        Integer n = lastId;
        Integer n2 = lastId = Integer.valueOf(lastId + 1);
        mid.append(lastId);
        generatedModelIds.put(mt, lastId);
        return mid.toString();
    }

    @Override
    public DataDictionary getDataDictionary() {
        if (this.getParentModel() == null) {
            return this.getOwner().getRawPMML().getDataDictionary();
        }
        return this.getParentModel().getDataDictionary();
    }

    @Override
    public Serializable getRawModel() {
        return (Serializable)this.rawModel;
    }

    static {
        helper = new PMML4Helper();
        generatedModelIds = new HashMap<String, Integer>();
        templateRegistry = new SimpleTemplateRegistry();
    }
}

