/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.dmg.pmml.pmml_4_2.descr.Segment;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.io.Resource;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4Compiler;
import org.kie.pmml.pmml_4_2.PMML4Model;
import org.kie.pmml.pmml_4_2.model.PMML4ModelFactory;
import org.kie.pmml.pmml_4_2.model.PMMLMiningField;
import org.kie.pmml.pmml_4_2.model.mining.CompoundSegmentPredicate;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegmentation;
import org.kie.pmml.pmml_4_2.model.mining.PredicateRuleProducer;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSegmentPredicate;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSetSegmentPredicate;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

@PropertyReactive
public class MiningSegment
implements Comparable<MiningSegment> {
    private String segmentId;
    private MiningSegmentation owner;
    private PredicateRuleProducer predicateRuleProducer;
    private boolean alwaysTrue;
    private PMML4Model internalModel;
    private String segmentAgendaId;
    private int segmentIndex;
    private static CompiledTemplate launchTemplate;
    private static final String segmentPackageRootName = "org.kie.pmml.pmml_4_2";

    public MiningSegment(MiningSegmentation owner, Segment segment, int segmentIndex) {
        this.owner = owner;
        this.internalModel = PMML4ModelFactory.getInstance().getModel(segment, owner);
        this.segmentId = segment.getId();
        this.segmentIndex = segmentIndex;
        if (segment.getSimplePredicate() != null) {
            this.predicateRuleProducer = new SimpleSegmentPredicate(segment.getSimplePredicate());
        } else if (segment.getSimpleSetPredicate() != null) {
            this.predicateRuleProducer = new SimpleSetSegmentPredicate(segment.getSimpleSetPredicate());
        } else if (segment.getCompoundPredicate() != null) {
            this.predicateRuleProducer = new CompoundSegmentPredicate(segment.getCompoundPredicate());
        } else if (segment.getTrue() != null) {
            this.alwaysTrue = true;
        }
    }

    public PMML4Model getModel() {
        return this.internalModel;
    }

    public boolean checkForMiningFieldMapping() {
        List<PMMLMiningField> miningFields = this.internalModel.getMiningFields();
        for (PMMLMiningField field : miningFields) {
            if (field.isInDictionary()) continue;
            System.out.println("must search for output named: " + field.getName());
        }
        return false;
    }

    public String getSegmentId() {
        if (this.segmentId == null || this.segmentId.trim().isEmpty()) {
            StringBuilder bldr = new StringBuilder(this.owner.getSegmentationId());
            bldr.append("Segment").append(this.segmentIndex);
            this.segmentId = bldr.toString();
        }
        return this.segmentId;
    }

    private synchronized CompiledTemplate getLaunchTemplate() {
        Resource res;
        if (launchTemplate == null && (res = ResourceFactory.newClassPathResource((String)"org/kie/pmml/pmml_4_2/templates/mvel/mining/selectFirstSegOnly.mvel")) != null) {
            try {
                launchTemplate = TemplateCompiler.compileTemplate((InputStream)res.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return launchTemplate;
    }

    public String generateSegmentRules(String segmentationAgenda, int segmentIndex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompiledTemplate template = this.getLaunchTemplate();
        if (template != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("segmentId", this.getSegmentId());
            vars.put("segmentationAgendaId", segmentationAgenda);
            vars.put("segmentSalience", new Integer(1000 - segmentIndex));
            if (this.predicateRuleProducer instanceof CompoundSegmentPredicate) {
                CompoundSegmentPredicate predProd = (CompoundSegmentPredicate)this.predicateRuleProducer;
                if (predProd.hasSurrogation()) {
                    vars.put("segmentPredicate", this.getSurrogationPredicateText(predProd, -1));
                } else {
                    vars.put("segmentPredicate", predProd.getPredicateRule());
                }
            } else {
                vars.put("segmentPredicate", this.predicateRuleProducer.getPredicateRule());
            }
            vars.put("miningPojoClass", this.getOwner().getOwner().getMiningPojoClassName());
            TemplateRuntime.execute((CompiledTemplate)template, null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (OutputStream)baos);
        }
        PMML pmml = new PMML();
        pmml.setDataDictionary(this.internalModel.getDataDictionary());
        pmml.getAssociationModelsAndBaselineModelsAndClusteringModels().add(this.internalModel.getRawModel());
        PMML4Compiler compiler = new PMML4Compiler();
        String innerRules = compiler.generateTheory(pmml);
        return new String(baos.toByteArray()).concat(innerRules);
    }

    private String getSurrogationPredicateText(CompoundSegmentPredicate predicate, int lastPredicate) {
        if (lastPredicate >= predicate.getSubpredicateCount()) {
            return "";
        }
        StringBuilder bldr = new StringBuilder();
        if (lastPredicate == -1) {
            bldr.append("(").append(predicate.getPrimaryPredicateRule()).append(")");
        } else {
            bldr.append(predicate.getNextPredicateRule(lastPredicate));
        }
        String subPredicate = this.getSurrogationPredicateText(predicate, lastPredicate + 1);
        if (subPredicate != null && !subPredicate.trim().isEmpty()) {
            bldr.append(" || ").append(subPredicate);
        }
        return bldr.toString();
    }

    public MiningSegmentation getOwner() {
        return this.owner;
    }

    public PredicateRuleProducer getPredicateRuleProducer() {
        return this.predicateRuleProducer;
    }

    public String getPredicateText() {
        return this.alwaysTrue ? "" : this.predicateRuleProducer.getPredicateRule();
    }

    public String getSegmentPackageName() {
        StringBuilder builder = new StringBuilder(segmentPackageRootName);
        builder.append(".mining.segment_").append(this.getSegmentId());
        return builder.toString();
    }

    public String getSegmentAgendaId() {
        if (this.segmentAgendaId == null || this.segmentAgendaId.trim().isEmpty()) {
            this.segmentAgendaId = this.getOwner().getSegmentationAgendaId().concat("_SEGMENT_" + this.getSegmentId());
        }
        return this.segmentAgendaId;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public boolean isAlwaysTrue() {
        return this.alwaysTrue;
    }

    public PMML4Model getInternalModel() {
        return this.internalModel;
    }

    @Override
    public int compareTo(MiningSegment ms) {
        if (ms.segmentIndex == this.segmentIndex) {
            return 0;
        }
        return ms.segmentIndex > this.segmentIndex ? 1 : -1;
    }
}

