/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.util.HashMap;
import java.util.Map;
import org.kie.pmml.pmml_4_2.PMML4Result;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;

public class MiningSegmentTransfer {
    private String correlationId;
    private String segmentationId;
    private String fromSegmentId;
    private String toSegmentId;
    private Map<String, String> requestFromResultMap;
    private PMMLRequestData outboundRequest;
    private PMML4Result inboundResult;

    public MiningSegmentTransfer(String segmentationId, String fromSegmentId, String toSegmentId) {
        this.segmentationId = segmentationId;
        this.fromSegmentId = fromSegmentId;
        this.toSegmentId = toSegmentId;
        this.requestFromResultMap = new HashMap<String, String>();
    }

    public MiningSegmentTransfer(PMML4Result inboundResult, String toSegmentId) {
        this.inboundResult = inboundResult;
        this.correlationId = inboundResult.getCorrelationId();
        this.segmentationId = inboundResult.getSegmentationId();
        this.fromSegmentId = inboundResult.getSegmentId();
        this.toSegmentId = toSegmentId;
        this.requestFromResultMap = new HashMap<String, String>();
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getSegmentationId() {
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    public String getFromSegmentId() {
        return this.fromSegmentId;
    }

    public void setFromSegmentId(String fromSegmentId) {
        this.fromSegmentId = fromSegmentId;
    }

    public String getToSegmentId() {
        return this.toSegmentId;
    }

    public void setToSegmentId(String toSegmentId) {
        this.toSegmentId = toSegmentId;
    }

    public PMMLRequestData getOutboundRequest() {
        if (this.outboundRequest == null) {
            this.outboundRequest = new PMMLRequestData(this.correlationId);
            this.outboundRequest.setSource("MiningSegmentTransfer:" + this.fromSegmentId + "-" + this.toSegmentId);
            for (String requestField : this.requestFromResultMap.keySet()) {
                String resultFieldName = this.requestFromResultMap.get(requestField);
                Object resultFieldValue = this.getValueFromResult(resultFieldName);
                if (resultFieldValue == null) continue;
                this.outboundRequest.addRequestParam(requestField, resultFieldValue);
            }
        }
        return this.outboundRequest;
    }

    public Map<String, String> getRequestFromResultMap() {
        return new HashMap<String, String>(this.requestFromResultMap);
    }

    private Object getValueFromResult(String fieldName) {
        if (fieldName.contains(".")) {
            String[] fieldParts = fieldName.split("\\.");
            if (fieldParts != null && fieldParts.length == 2) {
                return this.inboundResult.getResultValue(fieldParts[0], fieldParts[1], new Object[0]);
            }
            throw new IllegalStateException("MiningSegmentTransfer: Result field name is invalid - " + fieldName);
        }
        return this.inboundResult.getResultValue(fieldName, null, new Object[0]);
    }

    public void setOutboundRequest(PMMLRequestData outboundRequest) {
        this.outboundRequest = outboundRequest;
    }

    public PMML4Result getInboundResult() {
        return this.inboundResult;
    }

    public void setInboundResult(PMML4Result inboundResult) {
        this.inboundResult = inboundResult;
    }

    public Map<String, String> getResultFieldNameToRequestFieldName() {
        return this.requestFromResultMap;
    }

    public String addResultToRequestMapping(String resultFieldName, String requestFieldName) {
        return this.requestFromResultMap.put(requestFieldName, resultFieldName);
    }

    public void addResultToRequestMappings(Map<String, String> collection) {
        this.requestFromResultMap.putAll(collection);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.fromSegmentId == null ? 0 : this.fromSegmentId.hashCode());
        result = 31 * result + (this.segmentationId == null ? 0 : this.segmentationId.hashCode());
        result = 31 * result + (this.toSegmentId == null ? 0 : this.toSegmentId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiningSegmentTransfer other = (MiningSegmentTransfer)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.fromSegmentId == null ? other.fromSegmentId != null : !this.fromSegmentId.equals(other.fromSegmentId)) {
            return false;
        }
        if (this.segmentationId == null ? other.segmentationId != null : !this.segmentationId.equals(other.segmentationId)) {
            return false;
        }
        return !(this.toSegmentId == null ? other.toSegmentId != null : !this.toSegmentId.equals(other.toSegmentId));
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder("MiningSegmentTransfer [");
        bldr.append("correlationId=").append(this.correlationId).append(", ");
        bldr.append("segmentationId=").append(this.segmentationId).append(", ");
        bldr.append("fromSegmentId=").append(this.fromSegmentId).append(", ");
        bldr.append("toSegmentId=").append(this.toSegmentId).append(", ");
        bldr.append("resultFieldNameToRequestFieldName=").append(this.requestFromResultMap).append(", ");
        bldr.append("inboundResult=").append(this.inboundResult).append(", ");
        bldr.append("outboundRequest=").append(this.getOutboundRequest());
        bldr.append("]");
        return bldr.toString();
    }
}

