/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.KieBase;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieContext;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.pmml.pmml_4_2.PMML4Result;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecutionState;

@PropertyReactive
public class SegmentExecution
implements Comparable<SegmentExecution> {
    private String correlationId;
    private String segmentationId;
    private String segmentId;
    private int segmentIndex;
    private SegmentExecutionState state;
    private String agendaId;
    private PMMLRequestData requestData;
    private PMML4Result result;

    public SegmentExecution() {
    }

    public SegmentExecution(String correlationId, String segmentationId, String segmentId, int segmentIndex, String agendaId) {
        this.correlationId = correlationId;
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
        this.segmentIndex = segmentIndex;
        this.state = SegmentExecutionState.WAITING;
        this.agendaId = agendaId;
    }

    public SegmentExecution(String correlationId, String segmentationId, String segmentId, int segmentIndex, String state, String agendaId) {
        this.correlationId = correlationId;
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
        this.segmentIndex = segmentIndex;
        this.state = SegmentExecutionState.valueOf(state);
        this.agendaId = agendaId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getSegmentationId() {
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public SegmentExecutionState getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = SegmentExecutionState.valueOf(state);
    }

    public void setState(SegmentExecutionState state) {
        this.state = state;
    }

    public String getAgendaId() {
        return this.agendaId;
    }

    public void setAgendaId(String agendaId) {
        this.agendaId = agendaId;
    }

    public PMMLRequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(PMMLRequestData requestData) {
        this.requestData = requestData;
    }

    public PMML4Result getResult() {
        return this.result;
    }

    public void setResult(PMML4Result result) {
        this.result = result;
    }

    public void applySegmentModel(PMMLRequestData requestData, KieContext ctx) {
        KieBase kb = ctx.getKieRuntime().getKieBase();
        KnowledgeBaseImpl kbi = (KnowledgeBaseImpl)kb;
        InternalKieContainer container = kbi.getKieContainer();
        KieSession segmentSession = container.newKieSession("SEGMENT_" + this.segmentId);
        this.state = SegmentExecutionState.EXECUTING;
        FactHandle handle = ctx.getKieRuntime().getFactHandle((Object)this);
        ctx.getKieRuntime().update(handle, (Object)this);
        segmentSession.insert((Object)requestData);
        PMML4Result result = new PMML4Result(this);
        segmentSession.insert((Object)result);
        segmentSession.fireAllRules();
        this.result = result;
        segmentSession.dispose();
        ctx.getKieRuntime().insert((Object)result);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.segmentId == null ? 0 : this.segmentId.hashCode());
        result = 31 * result + this.segmentIndex;
        result = 31 * result + (this.segmentationId == null ? 0 : this.segmentationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentExecution other = (SegmentExecution)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.segmentId == null ? other.segmentId != null : !this.segmentId.equals(other.segmentId)) {
            return false;
        }
        if (this.segmentIndex != other.segmentIndex) {
            return false;
        }
        return !(this.segmentationId == null ? other.segmentationId != null : !this.segmentationId.equals(other.segmentationId));
    }

    @Override
    public int compareTo(SegmentExecution segEx) {
        if (this.segmentIndex == segEx.segmentIndex) {
            return 0;
        }
        return this.segmentIndex > segEx.segmentIndex ? 1 : -1;
    }

    public class SegmentEventListener
    extends DefaultAgendaEventListener {
        public void matchCancelled(MatchCancelledEvent event) {
            System.out.println("Match cancelled - " + event.getCause().name() + " - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void matchCreated(MatchCreatedEvent event) {
            System.out.println("Match created - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
            System.out.println("After match fired - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void beforeMatchFired(BeforeMatchFiredEvent event) {
            System.out.println("Before match fired - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }
    }
}

