/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.pmml.pmml_4_2.model.ParameterInfo;

public class PMMLRequestData {
    private String correlationId;
    private String modelName;
    private String source;
    private List<ParameterInfo<?>> requestParams;

    public PMMLRequestData(String correlationId) {
        this.correlationId = correlationId;
        this.requestParams = new ArrayList();
    }

    public PMMLRequestData(String correlationId, String modelName) {
        this.correlationId = correlationId;
        this.modelName = modelName;
        this.requestParams = new ArrayList();
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getCompactCapitalizedModelName() {
        String compactName = this.modelName.replaceAll("\\s", "");
        return compactName.substring(0, 1).toUpperCase() + compactName.substring(1);
    }

    public synchronized Map<String, ParameterInfo> getMappedRequestParams() {
        return this.requestParams.stream().collect(Collectors.toMap(pi -> pi.getName(), pi -> pi));
    }

    public synchronized Collection<ParameterInfo> getRequestParams() {
        return new ArrayList<ParameterInfo>(this.requestParams);
    }

    public synchronized boolean addRequestParam(ParameterInfo parameter) {
        return this.requestParams.add(parameter);
    }

    public synchronized boolean removeRequestParam(ParameterInfo parameter) {
        return this.requestParams.remove(parameter);
    }

    public synchronized boolean addRequestParam(String paramName, Object value) {
        if (paramName == null || paramName.trim().isEmpty() || value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        ParameterInfo<Object> parameter = new ParameterInfo<Object>(this.correlationId, paramName, clazz, value);
        return this.addRequestParam(parameter);
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.modelName == null ? 0 : this.modelName.hashCode());
        result = 31 * result + (this.requestParams == null ? 0 : this.requestParams.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMMLRequestData other = (PMMLRequestData)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName)) {
            return false;
        }
        if (this.requestParams == null ? other.requestParams != null : !this.requestParams.equals(other.requestParams)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PMMLRequestData( ");
        stringBuilder.append("correlationId=").append(this.correlationId).append(", ");
        stringBuilder.append("modelName=").append(this.modelName).append(", ");
        stringBuilder.append("source=").append(this.source).append(", requestParams=[");
        Iterator<ParameterInfo<?>> iter = this.requestParams.iterator();
        boolean firstParam = true;
        while (iter.hasNext()) {
            if (!firstParam) {
                stringBuilder.append(", ");
            } else {
                firstParam = false;
            }
            ParameterInfo<?> pi = iter.next();
            stringBuilder.append(pi.toString());
        }
        stringBuilder.append("] )");
        return stringBuilder.toString();
    }
}

