/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.pmml_4_2.descr.MULTIPLEMODELMETHOD;
import org.dmg.pmml.pmml_4_2.descr.Segment;
import org.dmg.pmml.pmml_4_2.descr.Segmentation;
import org.kie.api.io.Resource;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.model.Miningmodel;
import org.kie.pmml.pmml_4_2.model.PMMLMiningField;
import org.kie.pmml.pmml_4_2.model.PMMLOutputField;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegment;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegmentTransfer;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

public class MiningSegmentation {
    private Miningmodel owner;
    private String segmentationId;
    private MULTIPLEMODELMETHOD multipleModelMethod;
    private List<MiningSegment> miningSegments;
    private static TemplateRegistry templates;
    private static Map<String, String> templateNameToFile;
    private static final String segmentActivationSelectFirst = "org/kie/pmml/pmml_4_2/templates/mvel/mining/selectFirstSegOnly.mvel";
    private static final String segmentSelectAll = "org/kie/pmml/pmml_4_2/templates/mvel/mining/selectAllSegments.mvel";
    private static final String segmentModelChain = "org/kie/pmml/pmml_4_2/templates/mvel/mining/modelChain.mvel";

    public MiningSegmentation(Miningmodel owner, Segmentation segmentation) {
        this.owner = owner;
        this.multipleModelMethod = segmentation.getMultipleModelMethod();
        this.miningSegments = new ArrayList<MiningSegment>();
        this.initSegments(segmentation.getSegments());
        MiningSegmentation.initTemplates();
    }

    private void initSegments(List<Segment> segments) {
        if (segments != null && !segments.isEmpty()) {
            for (int index = 0; index < segments.size(); ++index) {
                Segment seg = segments.get(index);
                MiningSegment ms = new MiningSegment(this, seg, index);
                this.miningSegments.add(ms);
            }
        }
    }

    private static synchronized void initTemplates() {
        if (templates == null) {
            templates = new SimpleTemplateRegistry();
        }
        if (templateNameToFile == null) {
            templateNameToFile = new HashMap<String, String>();
            templateNameToFile.put(MULTIPLEMODELMETHOD.SELECT_FIRST.name(), segmentActivationSelectFirst);
            templateNameToFile.put(MULTIPLEMODELMETHOD.SELECT_ALL.name(), segmentSelectAll);
            templateNameToFile.put(MULTIPLEMODELMETHOD.MODEL_CHAIN.name(), segmentModelChain);
        }
    }

    public Miningmodel getOwner() {
        return this.owner;
    }

    public List<PMMLMiningField> getMiningFields() {
        return this.owner.getMiningFields();
    }

    public String getMiningPojoClassName() {
        return this.owner.getMiningPojoClassName();
    }

    public MULTIPLEMODELMETHOD getMultipleModelMethod() {
        return this.multipleModelMethod;
    }

    public String getMultipleModelHandling() {
        return this.multipleModelMethod.name();
    }

    public void setMultipleModelMethod(MULTIPLEMODELMETHOD multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
    }

    public List<MiningSegment> getMiningSegments() {
        return this.miningSegments;
    }

    public String getSegmentationId() {
        if (this.segmentationId == null || this.segmentationId.trim().length() < 1) {
            this.segmentationId = this.owner.getModelId().concat("Segmentation");
        }
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    private void loadTemplates(MULTIPLEMODELMETHOD mmm) {
        Resource res;
        if (!templates.contains(mmm.name()) && (res = ResourceFactory.newClassPathResource((String)templateNameToFile.get(mmm.name()), MiningSegmentation.class)) != null) {
            try {
                InputStream strm = res.getInputStream();
                templates.addNamedTemplate(mmm.name(), TemplateCompiler.compileTemplate((InputStream)strm));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MiningSegmentTransfer getSegmentTransfer(MiningSegment targetSegment, String targetFieldName) {
        MiningSegmentTransfer xfer = null;
        int lastIndex = targetSegment.getSegmentIndex() - 1;
        if (lastIndex < 0) {
            throw new IndexOutOfBoundsException("Cannot have an undefined mining field in the first segment");
        }
        for (int idx = lastIndex; idx >= 0; --idx) {
            List<PMMLOutputField> outputs;
            MiningSegment seg = this.miningSegments.get(idx);
            if (seg == null || seg.getInternalModel() == null || (outputs = seg.getInternalModel().getOutputFields()) == null) continue;
            for (PMMLOutputField field : outputs) {
                if (!field.getName().equals(targetFieldName)) continue;
                xfer = new MiningSegmentTransfer(this.segmentationId, seg.getSegmentId(), targetSegment.getSegmentId());
                xfer.addResultToRequestMapping(targetFieldName, targetFieldName);
                return xfer;
            }
        }
        return xfer;
    }

    public String generateSegmentationRules() {
        StringBuilder builder = new StringBuilder();
        this.loadTemplates(this.multipleModelMethod);
        HashMap<String, Object> templateVars = new HashMap<String, Object>();
        String pkgName = this.getOwner().getModelPackageName();
        CompiledTemplate ct = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switch (this.multipleModelMethod) {
            case AVERAGE: {
                break;
            }
            case MAJORITY_VOTE: {
                break;
            }
            case MAX: {
                break;
            }
            case MEDIAN: {
                break;
            }
            case MODEL_CHAIN: {
                ArrayList<MiningSegmentTransfer> segmentTransfers = new ArrayList<MiningSegmentTransfer>();
                MiningSegmentTransfer mst = new MiningSegmentTransfer(this.getSegmentationId(), "1", "2");
                mst.addResultToRequestMapping("calculatedScore", "calculatedScore");
                segmentTransfers.add(mst);
                templateVars.put("miningModel", this.getOwner());
                templateVars.put("childSegments", this.getMiningSegments());
                templateVars.put("packageName", pkgName);
                templateVars.put("resultMappings", segmentTransfers);
                ct = templates.getNamedTemplate(this.multipleModelMethod.name());
                TemplateRuntime.execute((CompiledTemplate)ct, null, (VariableResolverFactory)new MapVariableResolverFactory(templateVars), (OutputStream)baos);
                builder.append(new String(baos.toByteArray()));
                break;
            }
            case SELECT_ALL: {
                templateVars.put("ruleUnitClassName", this.getOwner().getRuleUnitClassName());
                templateVars.put("miningModel", this.getOwner());
                templateVars.put("childSegments", this.getMiningSegments());
                templateVars.put("packageName", pkgName);
                ct = templates.getNamedTemplate(this.multipleModelMethod.name());
                TemplateRuntime.execute((CompiledTemplate)ct, null, (VariableResolverFactory)new MapVariableResolverFactory(templateVars), (OutputStream)baos);
                builder.append(new String(baos.toByteArray()));
                break;
            }
            case SELECT_FIRST: {
                templateVars.put("ruleUnitClassName", this.getOwner().getRuleUnitClassName());
                templateVars.put("miningModel", this.getOwner());
                templateVars.put("childSegments", this.getMiningSegments());
                templateVars.put("packageName", pkgName);
                ct = templates.getNamedTemplate(this.multipleModelMethod.name());
                TemplateRuntime.execute((CompiledTemplate)ct, null, (VariableResolverFactory)new MapVariableResolverFactory(templateVars), (OutputStream)baos);
                builder.append(new String(baos.toByteArray()));
                break;
            }
            case SUM: {
                break;
            }
            case WEIGHTED_AVERAGE: {
                break;
            }
        }
        return builder.toString();
    }

    public String generateRulesForSegment(int index) {
        StringBuilder builder = new StringBuilder();
        String segRules = this.miningSegments.get(index).generateSegmentRules(this.getSegmentationAgendaId(), index);
        return segRules;
    }

    public String getSegmentationAgendaId() {
        return this.getOwner().getModelId() + "_" + this.getSegmentationId();
    }
}

