/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.drools.core.io.impl.ClassPathResource;
import org.kie.dmg.pmml.pmml_4_2.descr.DataDictionary;
import org.kie.dmg.pmml.pmml_4_2.descr.DataField;
import org.kie.dmg.pmml.pmml_4_2.descr.Extension;
import org.kie.dmg.pmml.pmml_4_2.descr.MiningField;
import org.kie.dmg.pmml.pmml_4_2.descr.PMML;
import org.kie.pmml.pmml_4_2.PMML4Model;
import org.kie.pmml.pmml_4_2.PMML4Unit;
import org.kie.pmml.pmml_4_2.model.Miningmodel;
import org.kie.pmml.pmml_4_2.model.PMML4ModelFactory;
import org.kie.pmml.pmml_4_2.model.PMML4ModelType;
import org.kie.pmml.pmml_4_2.model.PMMLDataField;

public class PMML4UnitImpl
implements PMML4Unit {
    public static String DEFAULT_ROOT_PACKAGE = "org.kie.pmml.pmml_4_2";
    private static PMML4ModelFactory modelFactory = PMML4ModelFactory.getInstance();
    private PMML rawPmml;
    private Map<String, PMML4Model> modelsMap;
    private Map<String, PMMLDataField> dataDictionaryMap;

    public PMML4UnitImpl(PMML rawPmml) {
        this.rawPmml = rawPmml;
        this.initFromPMML();
    }

    public PMML4UnitImpl(String pmmlSourcePath) {
        ClassPathResource resource = new ClassPathResource(pmmlSourcePath);
        try {
            JAXBContext context = JAXBContext.newInstance((String)PMML.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.rawPmml = (PMML)unmarshaller.unmarshal(resource.getInputStream());
            this.initFromPMML();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to resolve the PMML from the given input", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occurred while attempting to resolve the PMML from the given input", e);
        }
    }

    private void initFromPMML() {
        if (this.rawPmml != null) {
            this.initDataDictionaryMap();
            this.initModelsMap();
        }
    }

    private void initDataDictionaryMap() {
        DataDictionary dd = this.rawPmml.getDataDictionary();
        if (dd != null) {
            this.dataDictionaryMap = new HashMap<String, PMMLDataField>();
            for (DataField dataField : dd.getDataFields()) {
                PMMLDataField df = new PMMLDataField(dataField);
                this.dataDictionaryMap.put(df.getName(), df);
            }
        } else {
            throw new IllegalStateException("BRMS-PMML requires a data dictionary section in the definition file");
        }
    }

    private void initModelsMap() {
        this.modelsMap = new HashMap<String, PMML4Model>();
        List<PMML4Model> rootModels = modelFactory.getModels(this);
        if (rootModels != null && !rootModels.isEmpty()) {
            for (PMML4Model model : rootModels) {
                this.modelsMap.put(model.getModelId(), model);
                this.addChildModelsToMap(model);
            }
        } else {
            throw new IllegalStateException("BRMS-PMML requires at least one model of the model types that are recognized");
        }
    }

    private void addChildModelsToMap(PMML4Model parentModel) {
        Map<String, PMML4Model> childModels = parentModel.getChildModels();
        if (childModels != null && !childModels.isEmpty()) {
            for (PMML4Model model : childModels.values()) {
                this.modelsMap.put(model.getModelId(), model);
                this.addChildModelsToMap(model);
            }
        }
    }

    @Override
    public PMML getRawPMML() {
        return this.rawPmml;
    }

    public List<MiningField> getMiningFieldsForModel(String modelId) {
        PMML4Model model = this.modelsMap.get(modelId);
        if (model != null) {
            return model.getRawMiningFields();
        }
        return null;
    }

    public Map<String, List<MiningField>> getMiningFields() {
        HashMap<String, List<MiningField>> miningFieldsMap = new HashMap<String, List<MiningField>>();
        for (PMML4Model model : this.getModels()) {
            List<MiningField> miningFields = model.getRawMiningFields();
            miningFieldsMap.put(model.getModelId(), miningFields);
            model.getChildModels();
        }
        return miningFieldsMap;
    }

    public Map<String, PMML4Model> getModelsMap() {
        return this.modelsMap;
    }

    @Override
    public Map<String, PMML4Model> getRootModels() {
        HashMap<String, PMML4Model> rootModels = new HashMap<String, PMML4Model>();
        for (PMML4Model model : this.modelsMap.values()) {
            if (model.getParentModel() != null) continue;
            rootModels.put(model.getModelId(), model);
        }
        return rootModels;
    }

    @Override
    public Miningmodel getRootMiningModel() {
        for (PMML4Model model : this.modelsMap.values()) {
            if (model.getParentModel() != null || !(model instanceof Miningmodel)) continue;
            return (Miningmodel)model;
        }
        return null;
    }

    public Map<String, PMML4Model> getChildModels(String parentModelId) {
        PMML4Model parent = this.modelsMap.get(parentModelId);
        Map<String, PMML4Model> childMap = parent.getChildModels();
        return childMap != null && !childMap.isEmpty() ? new HashMap<String, PMML4Model>(childMap) : new HashMap<String, PMML4Model>();
    }

    public Map<String, PMML4Model> getModels(PMML4ModelType type, PMML4Model parent) {
        Map<String, PMML4Model> unfilteredModels;
        HashMap<String, PMML4Model> filteredModels = new HashMap<String, PMML4Model>();
        Map<String, PMML4Model> map = unfilteredModels = parent == null ? this.getRootModels() : this.getChildModels(parent.getModelId());
        if (unfilteredModels != null && !unfilteredModels.isEmpty()) {
            for (PMML4Model model : unfilteredModels.values()) {
                if (model.getModelType() != type) continue;
                filteredModels.put(model.getModelId(), model);
            }
        }
        return filteredModels;
    }

    @Override
    public PMML4Model getRootModel() {
        for (PMML4Model model : this.modelsMap.values()) {
            if (model.getParentModel() != null) continue;
            return model;
        }
        return null;
    }

    @Override
    public boolean containsMiningModel() {
        for (PMML4Model model : this.modelsMap.values()) {
            if (model.getModelType() != PMML4ModelType.MINING) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PMML4Model> getModels() {
        Collection<PMML4Model> models = this.getModelsMap().values();
        return models != null && !models.isEmpty() ? new ArrayList<PMML4Model>(models) : new ArrayList<PMML4Model>();
    }

    @Override
    public List<PMMLDataField> getDataDictionaryFields() {
        return this.dataDictionaryMap != null && !this.dataDictionaryMap.isEmpty() ? new ArrayList<PMMLDataField>(this.dataDictionaryMap.values()) : new ArrayList<PMMLDataField>();
    }

    @Override
    public Map<String, PMMLDataField> getDataDictionaryMap() {
        return new HashMap<String, PMMLDataField>(this.dataDictionaryMap);
    }

    private String packageFromRawPmml() {
        if (this.rawPmml.getHeader() != null && this.rawPmml.getHeader().getExtensions() != null) {
            for (Extension ext : this.rawPmml.getHeader().getExtensions()) {
                if (!"modelPackage".equals(ext.getName())) continue;
                return ext.getValue();
            }
        }
        return null;
    }

    @Override
    public String getRootPackage() {
        return this.packageFromRawPmml() != null ? this.packageFromRawPmml() : DEFAULT_ROOT_PACKAGE;
    }

    public Map<String, String> getModelPackageNames() {
        HashMap<String, String> packageNames = new HashMap<String, String>();
        packageNames.put("root", this.getRootPackage());
        for (PMML4Model model : this.getModels()) {
            packageNames.put(model.getModelId(), model.getModelPackageName());
        }
        return packageNames;
    }
}

