/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.dmg.pmml.pmml_4_2.descr.SimpleSetPredicate;
import org.kie.pmml.pmml_4_2.PMML4Helper;
import org.kie.pmml.pmml_4_2.model.mining.PredicateRuleProducer;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class SimpleSetSegmentPredicate
implements PredicateRuleProducer {
    private String setType;
    private String operator;
    private String baseFieldName;
    private String setValuesString;
    private BigInteger valueCount;
    private List<Object> valuesList;
    private static CompiledTemplate template;
    private static PMML4Helper helper;
    private static String PREDICATE_TEMPLATE;

    public SimpleSetSegmentPredicate(SimpleSetPredicate predicate) {
        this.setType = predicate.getArray().getType();
        this.operator = predicate.getBooleanOperator();
        this.baseFieldName = predicate.getField();
        this.setValuesString = predicate.getArray().getContent();
        this.valueCount = predicate.getArray().getN();
        this.valuesList = this.getValueObjects();
        if (this.valueCount != null && this.valueCount.intValue() != this.valuesList.size()) {
            throw new IllegalStateException("PMML-SimpleSetPredicate: Number of values found (" + this.valuesList.size() + ") does not equal number of values declared (" + this.valueCount + ")");
        }
        if (this.operator == null || !this.operator.equals("isIn") && !this.operator.equals("isNotIn")) {
            throw new IllegalStateException("PMML-SimpleSetPredicate: booleanOperator was not one of the allowed values (\"isIn\" or \"isNotIn\")");
        }
    }

    public String getSetType() {
        return this.setType;
    }

    public void setSetType(String setType) {
        this.setType = setType;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getFieldName() {
        return this.baseFieldName;
    }

    public String getCapitalizedFieldName() {
        return helper.compactAsJavaId(this.baseFieldName, true);
    }

    public String getMissingFieldName() {
        return "m".concat(this.getCapitalizedFieldName());
    }

    public String getValueFieldName() {
        return "v".concat(this.getCapitalizedFieldName());
    }

    public void setFieldName(String fieldName) {
        this.baseFieldName = fieldName;
    }

    public String getSetValues() {
        return this.setValuesString;
    }

    public void setSetValues(String setValues) {
        this.setValuesString = setValues;
    }

    private CompiledTemplate getTemplate() {
        if (template == null) {
            template = TemplateCompiler.compileTemplate((String)PREDICATE_TEMPLATE);
        }
        return template;
    }

    private Matcher getMatcher() {
        Pattern pattern = null;
        pattern = "int".equalsIgnoreCase(this.setType) ? Pattern.compile("\\b(\\d*)\\w+\\b") : ("real".equalsIgnoreCase(this.setType) ? Pattern.compile("\\b(\\d*\\.?\\d*\\w+)\\b") : Pattern.compile("\\b(?:(?<=\")[^\"]*(?=\")|\\w+)\\b"));
        if (pattern != null) {
            return pattern.matcher(this.setValuesString);
        }
        return null;
    }

    private List<Object> getValueObjects() {
        ArrayList<Object> objects;
        block7: {
            objects = new ArrayList<Object>();
            Matcher matcher = this.getMatcher();
            if (matcher == null) break block7;
            if ("int".equalsIgnoreCase(this.setType)) {
                while (matcher.find()) {
                    Integer value = Integer.valueOf(matcher.group(0));
                    objects.add(value);
                }
            } else if ("real".equals(this.setType)) {
                while (matcher.find()) {
                    String valueStr = matcher.group(0);
                    Double value = Double.valueOf(valueStr);
                    objects.add(value);
                }
            } else {
                while (matcher.find()) {
                    objects.add(matcher.group(0));
                }
            }
        }
        return objects;
    }

    private String getOperatorText() {
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("isIn")) {
                return "in";
            }
            if (this.operator.equalsIgnoreCase("isNotIn")) {
                return "not in";
            }
        }
        throw new IllegalStateException("PMML-SimpleSetPredicate: booleanOperator was not one of the allowed values (\"isIn\" or \"isNotIn\")");
    }

    @Override
    public String getPredicateRule() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompiledTemplate ct = this.getTemplate();
        if (ct != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("fieldName", this.getValueFieldName());
            vars.put("operator", this.getOperatorText());
            vars.put("setType", this.setType);
            vars.put("values", this.getValueObjects());
            TemplateRuntime.execute((CompiledTemplate)ct, null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (OutputStream)baos);
        }
        return new String(baos.toByteArray());
    }

    @Override
    public List<String> getPredicateFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(this.baseFieldName);
        return fieldNames;
    }

    @Override
    public List<String> getFieldMissingFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(this.getMissingFieldName());
        return fieldNames;
    }

    static {
        helper = new PMML4Helper();
        PREDICATE_TEMPLATE = "@{fieldName} @{operator} (@foreach{value: values}  @if{ setType==\"string\" }\"@{value}\" @elseif{ setType!=\"string\" }@{value}@end{}@end{\",\"} )";
    }
}

