/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RuleCompletionProposal
implements ICompletionProposal {
    private String content;
    private String display;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private int priority;

    public RuleCompletionProposal(int replacementOffset, int replacementLength, String content) {
        this(replacementOffset, replacementLength, content, content);
    }

    public RuleCompletionProposal(int replacementOffset, int replacementLength, String display, String content) {
        this(replacementOffset, replacementLength, display, content, content.length());
    }

    public RuleCompletionProposal(int replacementOffset, int replacementLength, String display, String content, Image image) {
        this(replacementOffset, replacementLength, display, content, content.length(), image);
    }

    public RuleCompletionProposal(int replacementOffset, int replacementLength, String display, String content, int cursorPosition) {
        this(replacementOffset, replacementLength, display, content, cursorPosition, null);
    }

    public RuleCompletionProposal(int replacementOffset, int replacementLength, String display, String content, int cursorPosition, Image image) {
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.content = content;
        this.display = display;
        this.cursorPosition = cursorPosition;
        this.image = image;
    }

    public String getDisplay() {
        return this.display;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public Image getImage() {
        return this.image;
    }

    public String getContent() {
        return this.content;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String toString() {
        return this.content;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.content);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.display != null) {
            return this.display;
        }
        return this.content;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleCompletionProposal other = (RuleCompletionProposal)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        return !(this.display == null ? other.display != null : !this.display.equals(other.display));
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public static class RuleCompletionProposalComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof RuleCompletionProposal) {
                if (arg1 instanceof RuleCompletionProposal) {
                    RuleCompletionProposal prop0 = (RuleCompletionProposal)arg0;
                    RuleCompletionProposal prop1 = (RuleCompletionProposal)arg1;
                    if (prop0.getPriority() == prop1.getPriority()) {
                        return prop0.display.compareTo(prop1.display);
                    }
                    if (prop0.getPriority() > prop1.getPriority()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (arg1 instanceof RuleCompletionProposal) {
                return 1;
            }
            return 0;
        }
    }
}

