/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import org.drools.compiler.DrlParser;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.editors.DRLDocumentProvider;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.rulebuilder.editors.BrlPage;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RuleEditor
extends FormEditor
implements IResourceChangeListener {
    private BrlPage guidedEditor;
    private TextEditor xmlEditor = new TextEditor();
    private SuggestionCompletionEngine completion;
    private SuggestionCompletionLoader loader;
    private FileEditorInput packageEditorInput;
    private final Document drlDocument;
    private IResourceChangeListener packageFileTracker = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IPath p2;
            IResourceDelta delta;
            IPath p1;
            if (RuleEditor.this.packageEditorInput != null && (p1 = (delta = RuleEditor.this.getRootDelta(event.getDelta())).getFullPath()).equals((Object)(p2 = RuleEditor.this.packageEditorInput.getFile().getFullPath()))) {
                RuleEditor.this.reloadCompletionEngine();
            }
        }
    };

    public RuleEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.packageFileTracker, 1);
        this.drlDocument = new Document();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(DroolsEclipsePlugin.getDefault().getRuleBuilderFormColors(display));
    }

    protected void addPages() {
        this.guidedEditor = new BrlPage(this);
        try {
            this.addPage((IFormPage)this.guidedEditor);
            this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            DRLRuleEditor drlEditor = new DRLRuleEditor(){

                protected IDocumentProvider createDocumentProvider() {
                    return new DRLDocumentProvider(){

                        public boolean isReadOnly(Object element) {
                            return true;
                        }

                        public boolean isModifiable(Object element) {
                            return false;
                        }

                        protected IDocument getParentDocument(Object element) {
                            return RuleEditor.this.drlDocument;
                        }
                    };
                }
            };
            this.addPage((IEditorPart)drlEditor, this.xmlEditor.getEditorInput());
            IPath packagePath = this.getCurrentDirectoryPath(this.getEditorInput());
            if (packagePath != null) {
                packagePath = packagePath.append("drools.package");
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(packagePath);
                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                URLClassLoader classLoader = ProjectClassLoader.getProjectClassLoader(javaProject);
                this.loader = new SuggestionCompletionLoader((ClassLoader)classLoader);
                if (!file.exists()) {
                    String defaultHeader = "//This is a package configuration file";
                    defaultHeader = String.valueOf(defaultHeader) + "\n//Add imports, globals etc here which will be used by all the rule assets in this folder.";
                    ByteArrayInputStream is = new ByteArrayInputStream(defaultHeader.getBytes());
                    try {
                        file.create((InputStream)is, true, null);
                    }
                    catch (CoreException e) {
                        DroolsEclipsePlugin.log(e);
                    }
                }
                this.packageEditorInput = new FileEditorInput(file);
            }
            this.reloadCompletionEngine();
            this.setPageText(1, "BRL Source");
            this.setPageText(2, "Generated DRL (read-only)");
            this.updateName(false);
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private void updateName(boolean forced) {
        String name = this.xmlEditor.getTitle();
        this.setPartName(name);
        if (this.guidedEditor.getModeller() != null && this.guidedEditor.getModeller().getModel() != null && (this.guidedEditor.getModeller().getModel().name == null || forced)) {
            String shortName;
            this.guidedEditor.getModeller().getModel().name = shortName = name.substring(0, name.length() - ".brl".length());
        }
        this.updateDRLPage();
    }

    private IPath getCurrentDirectoryPath(IEditorInput editorInput) {
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile().getFullPath().removeLastSegments(1).addTrailingSeparator();
        }
        return null;
    }

    private void reloadCompletionEngine() {
        if (this.packageEditorInput == null) {
            this.completion = new SuggestionCompletionLoader(null).getSuggestionEngine("", new ArrayList(), new ArrayList());
            return;
        }
        try {
            IPath p = this.packageEditorInput.getFile().getFullPath().removeLastSegments(1);
            Container folder = (Container)ResourcesPlugin.getWorkspace().getRoot().findMember(p, false);
            IResource[] files = folder.members(false);
            ArrayList<DSLTokenizedMappingFile> dslList = new ArrayList<DSLTokenizedMappingFile>();
            ArrayList<String> enumList = new ArrayList<String>();
            int i = 0;
            while (i < files.length) {
                String contents;
                String fn = files[i].getName();
                if (fn.endsWith(".dsl")) {
                    DSLTokenizedMappingFile dsl = new DSLTokenizedMappingFile();
                    contents = this.getFileContents((IFile)files[i]);
                    if (dsl.parseAndLoad((Reader)new StringReader(contents))) {
                        dslList.add(dsl);
                    }
                } else if (fn.endsWith(".enumeration")) {
                    contents = this.getFileContents((IFile)files[i]);
                    enumList.add(contents);
                }
                ++i;
            }
            String str = this.getFileContents(this.packageEditorInput.getFile());
            this.completion = this.loader.getSuggestionEngine(str, Collections.EMPTY_LIST, dslList, enumList);
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    private String getFileContents(IFile file) {
        try {
            int n;
            InputStream is = file.getContents();
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[4096];
            while ((n = is.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            return out.toString();
        }
        catch (CoreException coreException) {
            return "";
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean isDirty() {
        return this.xmlEditor.isDirty() || this.guidedEditor.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IDocument document = this.getInputDocument();
        if (newPageIndex == 0) {
            boolean newModel;
            boolean bl = newModel = this.guidedEditor.getModeller().getModel() == null;
            if (this.xmlEditor.isDirty() || newModel) {
                this.guidedEditor.setModelXML(document.get());
                if (newModel) {
                    this.guidedEditor.getModeller().setDirty(false);
                }
                this.updateName(false);
            }
            this.guidedEditor.refresh();
        } else if (newPageIndex == 1) {
            if (this.guidedEditor.isDirty()) {
                document.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
            }
        } else if (newPageIndex == 2) {
            if (this.guidedEditor.isDirty()) {
                document.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
            } else if (this.xmlEditor.isDirty()) {
                this.guidedEditor.setModelXML(document.get());
            }
            this.updateDRLPage();
            this.updateName(false);
        }
    }

    private void updateDRLPage() {
        String drl = "";
        try {
            drl = BRDRLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel());
            IResource resource = ResourceUtil.getResource((IEditorInput)this.xmlEditor.getEditorInput());
            Reader reader = DSLAdapter.getDSLContent(drl, resource);
            DrlParser parser = new DrlParser();
            if (reader != null) {
                drl = parser.getExpandedDRL(drl, reader);
            }
        }
        catch (Throwable t) {
            StringWriter strwriter = new StringWriter();
            t.printStackTrace(new PrintWriter(strwriter));
            drl = "\nPROBLEM WITH THE DRL CONVERSION!\n\n\nDRL:\n" + drl + "\n\nSTACKTRACE:\n" + strwriter.toString();
        }
        this.drlDocument.set(drl);
    }

    public void doSave(IProgressMonitor monitor) {
        IDocument document = this.getInputDocument();
        if (this.xmlEditor.isDirty()) {
            this.guidedEditor.setModelXML(document.get());
        } else if (this.guidedEditor.isDirty()) {
            document.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
        }
        this.xmlEditor.doSave(monitor);
        this.guidedEditor.getModeller().setDirty(false);
        this.guidedEditor.refresh();
    }

    private IDocument getInputDocument() {
        IEditorInput input = this.getEditorInput();
        IDocumentProvider docProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocument document = docProvider.getDocument((Object)input);
        return document;
    }

    public void doSaveAs() {
        this.xmlEditor.doSaveAs();
        this.guidedEditor.getModeller().setDirty(false);
        this.updateName(true);
        this.setInput(this.xmlEditor.getEditorInput());
        this.guidedEditor.refresh();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = RuleEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)RuleEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(RuleEditor.this.xmlEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.packageFileTracker);
        super.dispose();
    }

    public void dirtyPropertyChanged() {
        this.firePropertyChange(257);
        this.guidedEditor.refresh();
    }

    public SuggestionCompletionEngine getCompletionEngine() {
        return this.completion;
    }

    private IResourceDelta getRootDelta(IResourceDelta delta) {
        if (delta.getAffectedChildren().length > 0) {
            return this.getRootDelta(delta.getAffectedChildren()[0]);
        }
        return delta;
    }
}

