/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.ruleflow.view.property.color.ColorPropertyDescriptor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultElementWrapper
implements ElementWrapper,
IPropertySource,
Serializable {
    private static final long serialVersionUID = 510L;
    private static boolean allowNodeCustomization = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.Flow.AllowNodeCustomization");
    protected static IPropertyDescriptor[] DESCRIPTORS = allowNodeCustomization ? new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Name", "Name"), new TextPropertyDescriptor("Id", "Id"){

        public CellEditor createPropertyEditor(Composite parent) {
            return null;
        }
    }, new ColorPropertyDescriptor("Color", "Color")} : new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Name", "Name"), new TextPropertyDescriptor("Id", "Id"){

        public CellEditor createPropertyEditor(Composite parent) {
            return null;
        }
    }};
    public static final String NAME = "Name";
    public static final String ID = "Id";
    public static final String COLOR = "Color";
    private Object element;
    private ElementContainer parent;
    private transient Rectangle constraint;
    private List<ElementConnection> incomingConnections = new ArrayList<ElementConnection>();
    private List<ElementConnection> outgoingConnections = new ArrayList<ElementConnection>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();
    protected Color color;

    protected void setElement(Object element) {
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    @Override
    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
        this.internalSetConstraint(constraint);
        this.notifyListeners(3);
    }

    protected abstract void internalSetConstraint(Rectangle var1);

    @Override
    public Rectangle getConstraint() {
        if (this.constraint == null) {
            this.constraint = this.internalGetConstraint();
        }
        return this.constraint;
    }

    protected abstract Rectangle internalGetConstraint();

    @Override
    public void setParent(ElementContainer parent) {
        this.parent = parent;
    }

    @Override
    public ElementContainer getParent() {
        return this.parent;
    }

    @Override
    public List<ElementConnection> getOutgoingConnections() {
        return Collections.unmodifiableList(this.outgoingConnections);
    }

    @Override
    public List<ElementConnection> getIncomingConnections() {
        return Collections.unmodifiableList(this.incomingConnections);
    }

    @Override
    public void addIncomingConnection(ElementConnection connection) {
        this.localAddIncomingConnection(connection);
        this.internalAddIncomingConnection(connection);
        this.notifyListeners(1);
    }

    @Override
    public void localAddIncomingConnection(ElementConnection connection) {
        this.incomingConnections.add(connection);
    }

    protected void internalAddIncomingConnection(ElementConnection connection) {
    }

    @Override
    public void removeIncomingConnection(ElementConnection connection) {
        this.incomingConnections.remove(connection);
        this.internalRemoveIncomingConnection(connection);
        this.notifyListeners(1);
    }

    protected void internalRemoveIncomingConnection(ElementConnection connection) {
    }

    @Override
    public void addOutgoingConnection(ElementConnection connection) {
        this.localAddOutgoingConnection(connection);
        this.internalAddOutgoingConnection(connection);
        this.notifyListeners(2);
    }

    @Override
    public void localAddOutgoingConnection(ElementConnection connection) {
        this.outgoingConnections.add(connection);
    }

    protected void internalAddOutgoingConnection(ElementConnection connection) {
    }

    @Override
    public void removeOutgoingConnection(ElementConnection connection) {
        this.outgoingConnections.remove(connection);
        this.internalRemoveOutgoingConnection(connection);
        this.notifyListeners(2);
    }

    protected void internalRemoveOutgoingConnection(ElementConnection connection) {
    }

    @Override
    public void setName(String name) {
        this.internalSetName(name);
        this.notifyListeners(4);
    }

    protected void internalSetName(String name) {
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.internalGetColor();
        }
        return this.color;
    }

    protected Color internalGetColor() {
        return null;
    }

    public void setColor(Color color) {
        this.color = color;
        this.internalSetColor(color == null ? null : DefaultElementWrapper.RGBToInteger(color.getRGB()));
        this.notifyListeners(4);
    }

    protected void internalSetColor(Integer color) {
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(int change) {
        ModelEvent event = new ModelEvent(change);
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (ID.equals(id)) {
            return this.getId();
        }
        if (COLOR.equals(id)) {
            return this.getColor();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
        if (NAME.equals(id)) {
            this.setName("");
        }
        if (COLOR.equals(id)) {
            this.setColor(null);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (NAME.equals(id)) {
            this.setName((String)value);
        }
        if (COLOR.equals(id)) {
            this.setColor((Color)value);
        }
    }

    public static Integer RGBToInteger(RGB rgb) {
        return new Integer(rgb.blue << 16 | rgb.green << 8 | rgb.red);
    }

    public static RGB integerToRGB(Integer color) {
        int n = color;
        return new RGB(n & 0xFF, (n & 0xFF00) >> 8, (n & 0xFF0000) >> 16);
    }
}

