/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddNewFactConstraintDialog;
import org.drools.eclipse.rulebuilder.ui.FactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CompositeFactPatternWidget
extends Widget {
    private final CompositeFactPattern pattern;

    public CompositeFactPatternWidget(FormToolkit toolkit, Composite parent, RuleModeller mod, CompositeFactPattern factPattern, int idx) {
        super(parent, toolkit, mod, idx);
        this.pattern = factPattern;
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        parent.setLayout((Layout)layout);
        this.create();
    }

    private void create() {
        Label l = this.toolkit.createLabel(this.parent, HumanReadable.getCEDisplayName(this.pattern.type));
        GridData labelGD = new GridData(1808);
        labelGD.horizontalSpan = 2;
        l.setLayoutData((Object)labelGD);
        l.setBackground(new Color((Device)this.parent.getShell().getDisplay(), 240, 240, 240));
        l.setLayoutData((Object)labelGD);
        this.addDeleteAction();
        this.addMoreOptionsAction();
        Composite composite = this.toolkit.createComposite(this.parent);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 0x1000000;
        composite.setLayoutData((Object)gd);
        this.createFactRows(this.toolkit, composite);
    }

    protected void addDeleteAction() {
        ImageHyperlink delWholeLink = this.addImage(this.parent, "icons/delete_obj.gif");
        delWholeLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this ENTIRE condition, and all the field constraints that belong to it.");
                dialog.setText("Remove this entire condition?");
                if (dialog.open() == 64) {
                    if (CompositeFactPatternWidget.this.getModeller().getModel().removeLhsItem(CompositeFactPatternWidget.this.index)) {
                        CompositeFactPatternWidget.this.getModeller().reloadLhs();
                        CompositeFactPatternWidget.this.getModeller().setDirty(true);
                    } else {
                        CompositeFactPatternWidget.this.showMessage("Can't remove that item as it is used in the action part of the rule.");
                    }
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delWholeLink.setToolTipText("Remove the entire composite condition.");
    }

    private void addMoreOptionsAction() {
        ImageHyperlink link = this.addImage(this.parent, "icons/new_item.gif");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                AddNewFactConstraintDialog popup = new AddNewFactConstraintDialog(CompositeFactPatternWidget.this.parent.getShell(), CompositeFactPatternWidget.this.getModeller(), CompositeFactPatternWidget.this.pattern);
                popup.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setToolTipText("Add a fact to this constraint. If it is an 'or' type, it will need at least 2.");
    }

    private void createFactRows(FormToolkit toolkit, Composite constraintComposite) {
        if (this.pattern.getPatterns() != null) {
            FactPattern[] facts = (FactPattern[])this.pattern.getPatterns();
            int i = 0;
            while (i < facts.length) {
                new FactPatternWidget(toolkit, constraintComposite, this.getModeller(), facts[i], this.pattern, i, false);
                toolkit.createLabel(constraintComposite, "");
                toolkit.createLabel(constraintComposite, "");
                ++i;
            }
        }
    }
}

