/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.core.util.DateUtils;
import org.drools.eclipse.rulebuilder.ui.ModelWidget;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class DSLSentenceWidget
extends Widget {
    private static final String ENUM_TAG = "ENUM";
    private static final String DATE_TAG = "DATE";
    private static final String BOOLEAN_TAG = "BOOLEAN";
    private static final String ITEM_ = "ITEM_";
    private final DSLSentence sentence;
    protected SuggestionCompletionEngine completions;
    private List<ModelWidget> widgets = new ArrayList<ModelWidget>();

    public DSLSentenceWidget(FormToolkit toolkit, Composite parent, DSLSentence sentence, RuleModeller modeller, int index) {
        super(parent, toolkit, modeller, index);
        this.sentence = sentence;
        this.completions = modeller.getSuggestionCompletionEngine();
        Composite lastRow = this.makeWidgets(this.sentence.sentence);
        this.addDeleteAction(lastRow);
        toolkit.paintBordersFor(parent);
    }

    protected abstract void updateModel();

    private void addDeleteAction(Composite parent) {
        ImageHyperlink delLink = this.addImage(parent, "icons/delete_item_small.gif");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this DSL sentence?");
                dialog.setText("Remove this DSL sentence?");
                if (dialog.open() == 64) {
                    DSLSentenceWidget.this.updateModel();
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delLink.setToolTipText("Remove this condition.");
    }

    public Composite makeWidgets(String dslLine) {
        ArrayList<ModelWidget> lineWidgets = new ArrayList<ModelWidget>();
        int startVariable = dslLine.indexOf("{");
        boolean firstOneIsBracket = dslLine.indexOf("{") == 0;
        String startLabel = "";
        if (startVariable > 0) {
            startLabel = dslLine.substring(0, startVariable);
        } else if (!firstOneIsBracket) {
            startLabel = dslLine;
        }
        this.parent.setLayout((Layout)new GridLayout(1, true));
        Composite row = this.toolkit.createComposite(this.parent);
        RowLayout rl = new RowLayout();
        rl.marginBottom = 0;
        rl.marginHeight = 0;
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.pack = true;
        rl.spacing = 0;
        rl.center = true;
        row.setLayout((Layout)rl);
        lineWidgets.add(new LabelWidget(row, startLabel));
        while (startVariable > 0 || firstOneIsBracket) {
            firstOneIsBracket = false;
            int endVariable = dslLine.indexOf("}", startVariable);
            String currVariable = dslLine.substring(startVariable + 1, endVariable);
            lineWidgets.add(this.addVariable(row, currVariable));
            startVariable = dslLine.indexOf("{", endVariable);
            String lbl = startVariable > 0 ? dslLine.substring(endVariable + 1, startVariable) : dslLine.substring(endVariable + 1, dslLine.length());
            if (lbl.indexOf("\\n") > -1) {
                String[] lines = lbl.split("\\\\n");
                int i = 0;
                while (i < lines.length) {
                    row = this.toolkit.createComposite(this.parent);
                    row.setLayout((Layout)rl);
                    lineWidgets.add(new NewLine(row));
                    lineWidgets.add(new LabelWidget(row, lines[i]));
                    ++i;
                }
                continue;
            }
            lineWidgets.add(new LabelWidget(row, lbl));
        }
        for (ModelWidget widg : lineWidgets) {
            this.widgets.add(widg);
        }
        this.updateSentence();
        return row;
    }

    public ModelWidget addVariable(Composite parent, String currVariable) {
        int colonIndex = currVariable.indexOf(":");
        if (colonIndex > 0) {
            String definition = currVariable.substring(colonIndex + 1, currVariable.length());
            int secondColonIndex = definition.indexOf(":");
            if (secondColonIndex > 0) {
                String type = currVariable.substring(colonIndex + 1, colonIndex + secondColonIndex + 1);
                if (type.equalsIgnoreCase(ENUM_TAG)) {
                    return this.addEnumDropdown(parent, currVariable);
                }
                if (type.equalsIgnoreCase(DATE_TAG)) {
                    return this.addDateSelector(parent, currVariable);
                }
                if (type.equalsIgnoreCase(BOOLEAN_TAG)) {
                    return this.addCheckbox(parent, currVariable);
                }
            } else {
                String regex = currVariable.substring(colonIndex + 1, currVariable.length());
                return this.addBox(parent, currVariable, regex);
            }
        }
        return this.addBox(parent, currVariable, "");
    }

    public ModelWidget addBox(Composite parent, String variableDef, String regex) {
        int colonIndex = variableDef.indexOf(":");
        if (colonIndex > 0) {
            variableDef = variableDef.substring(0, colonIndex);
        }
        FieldEditor currentBox = new FieldEditor(parent);
        currentBox.setVisibleLength(variableDef.length() + 1);
        currentBox.setText(variableDef);
        currentBox.setRestriction(regex);
        return currentBox;
    }

    public ModelWidget addCheckbox(Composite parent, String variableDef) {
        return new DSLCheckBox(parent, variableDef);
    }

    public ModelWidget addDateSelector(Composite parent, String variableDef) {
        return new DSLDateSelector(parent, variableDef);
    }

    private ModelWidget addEnumDropdown(Composite parent, String variableDef) {
        return new DSLDropDown(parent, variableDef);
    }

    protected void updateSentence() {
        String newSentence = "";
        for (ModelWidget wid : this.widgets) {
            if (wid instanceof LabelWidget) {
                newSentence = String.valueOf(newSentence) + ((LabelWidget)wid).getText();
                continue;
            }
            if (wid instanceof FieldEditor) {
                FieldEditor editor = (FieldEditor)wid;
                String varString = editor.getText();
                String restriction = editor.getRestriction();
                if (!restriction.equals("")) {
                    varString = String.valueOf(varString) + ":" + restriction;
                }
                newSentence = String.valueOf(newSentence) + " {" + varString + "} ";
                continue;
            }
            if (wid instanceof DSLDropDown) {
                DSLDropDown drop = (DSLDropDown)wid;
                Combo box = (Combo)drop.getControl();
                String type = drop.getType();
                String factAndField = drop.getFactAndField();
                String key = ITEM_ + (box.getSelectionIndex() + 1);
                Object keyval = box.getData(key);
                newSentence = String.valueOf(newSentence) + "{" + keyval + ":" + type + ":" + factAndField + "} ";
                continue;
            }
            if (wid instanceof DSLCheckBox) {
                DSLCheckBox check = (DSLCheckBox)wid;
                String checkValue = check.getCheckedValue();
                newSentence = String.valueOf(newSentence) + "{" + checkValue + ":" + check.getType() + ":" + checkValue + "} ";
                continue;
            }
            if (wid instanceof DSLDateSelector) {
                DSLDateSelector dateSel = (DSLDateSelector)wid;
                String dateString = dateSel.getDateString();
                String format = dateSel.getJavascriptFormat();
                newSentence = String.valueOf(newSentence) + "{" + dateString + ":" + dateSel.getType() + ":" + format + "} ";
                continue;
            }
            if (!(wid instanceof NewLine)) continue;
            newSentence = String.valueOf(newSentence) + "\\n";
        }
        this.sentence.sentence = newSentence.trim();
    }

    class DSLCheckBox
    implements ModelWidget {
        Combo resultWidget = null;
        private String varName = "";
        private Composite control;

        public DSLCheckBox(Composite parent, String variableDef) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(parent);
            this.control.setLayout((Layout)new RowLayout());
            int firstIndex = variableDef.indexOf(":");
            int lastIndex = variableDef.lastIndexOf(":");
            this.varName = variableDef.substring(0, firstIndex);
            String checkedUnchecked = variableDef.substring(lastIndex + 1, variableDef.length());
            this.resultWidget = new Combo(this.control, 8);
            this.resultWidget.add("true");
            this.resultWidget.add("false");
            if (checkedUnchecked.equalsIgnoreCase("true")) {
                this.resultWidget.select(0);
            } else {
                this.resultWidget.select(1);
            }
            this.resultWidget.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DSLSentenceWidget.this.updateSentence();
                    ((DSLCheckBox)DSLCheckBox.this).DSLSentenceWidget.this.modeller.setDirty(true);
                }
            });
            this.resultWidget.setVisible(true);
            this.control.layout();
        }

        public Control getControl() {
            return this.control;
        }

        public Combo getListBox() {
            return this.resultWidget;
        }

        public void setListBox(Combo resultWidget) {
            this.resultWidget = resultWidget;
        }

        public String getType() {
            return DSLSentenceWidget.BOOLEAN_TAG;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public String getCheckedValue() {
            return this.resultWidget.getSelectionIndex() == 0 ? "true" : "false";
        }
    }

    class DSLDateSelector
    implements ModelWidget {
        private String varName = "";
        private String javascriptFormat = "";
        private final String defaultJavascriptFormat = "d-M-y";
        private final String javaFormat = DateUtils.getDateFormatMask();
        private SimpleDateFormat formatter = null;
        private Composite control;
        private Text field;

        public DSLDateSelector(Composite parent, String variableDef) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(parent);
            this.control.setLayout((Layout)new RowLayout());
            int firstIndex = variableDef.indexOf(":");
            int lastIndex = variableDef.lastIndexOf(":");
            this.varName = variableDef.substring(0, firstIndex);
            this.javascriptFormat = variableDef.substring(lastIndex + 1, variableDef.length());
            if (this.javascriptFormat.equals("") || this.javascriptFormat.equals("default")) {
                this.javascriptFormat = "d-M-y";
            }
            this.formatter = new SimpleDateFormat(this.javaFormat);
            Date origDate = new Date();
            if (!this.varName.equals("")) {
                try {
                    origDate = this.formatter.parse(this.varName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.field = DSLSentenceWidget.this.toolkit.createText(this.control, "");
            final Button open = new Button(this.control, 1028);
            if (origDate != null) {
                this.field.setText(this.formatter.format(origDate));
            }
            this.field.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DSLSentenceWidget.this.updateSentence();
                    ((DSLDateSelector)DSLDateSelector.this).DSLSentenceWidget.this.modeller.setDirty(true);
                }
            });
            open.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final Shell dialog = new Shell(open.getShell(), 67680);
                    dialog.setText("Set date:");
                    dialog.setLayout((Layout)new GridLayout(1, false));
                    final DateTime calendar = new DateTime((Composite)dialog, 1024);
                    Date date = new Date();
                    try {
                        String txt = DSLDateSelector.this.field.getText();
                        if (txt != null && txt.length() > 0) {
                            date = DSLDateSelector.this.formatter.parse(txt);
                        }
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    calendar.setDate(date.getYear() + 1900, date.getMonth(), date.getDate());
                    Point p2 = open.toDisplay(0, 0);
                    int x = p2.x;
                    int y = p2.y + 20;
                    dialog.setLocation(x, y);
                    Button ok = new Button((Composite)dialog, 8);
                    ok.setText("OK");
                    ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                    ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            DSLDateSelector.this.field.setText(DSLDateSelector.this.formatter.format(new Date(calendar.getYear() - 1900, calendar.getMonth(), calendar.getDay())));
                            DSLSentenceWidget.this.updateSentence();
                            ((DSLDateSelector)(this).DSLDateSelector.this).DSLSentenceWidget.this.modeller.setDirty(true);
                            dialog.close();
                        }
                    });
                    dialog.setDefaultButton(ok);
                    dialog.pack();
                    dialog.open();
                }
            });
            this.control.layout();
        }

        public Control getControl() {
            return this.control;
        }

        public String getType() {
            return DSLSentenceWidget.DATE_TAG;
        }

        public String getJavascriptFormat() {
            return this.javascriptFormat;
        }

        public String getDateString() {
            Date value = new Date();
            try {
                String txt = this.field.getText();
                if (txt != null && txt.length() > 0) {
                    value = this.formatter.parse(txt);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                return "";
            }
            String result = "";
            result = value != null ? this.formatter.format(value) : this.varName;
            return result;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }
    }

    class DSLDropDown
    implements ModelWidget {
        Combo resultWidget = null;
        private String varName = "";
        private String type = "";
        private String factAndField = "";

        public DSLDropDown(Composite parent, String variableDef) {
            Composite comp = DSLSentenceWidget.this.toolkit.createComposite(parent);
            comp.setLayout((Layout)new FillLayout());
            int firstIndex = variableDef.indexOf(":");
            int lastIndex = variableDef.lastIndexOf(":");
            this.varName = variableDef.substring(0, firstIndex);
            this.type = variableDef.substring(firstIndex + 1, lastIndex);
            this.factAndField = variableDef.substring(lastIndex + 1, variableDef.length());
            int dotIndex = this.factAndField.indexOf(".");
            String type = this.factAndField.substring(0, dotIndex);
            String field = this.factAndField.substring(dotIndex + 1, this.factAndField.length());
            String[] data = DSLSentenceWidget.this.completions.getEnumValues(type, field);
            Combo list = new Combo(comp, 12);
            if (data != null) {
                int selected = 0;
                int i = 0;
                while (i < data.length) {
                    String realValue = data[i];
                    String display = data[i];
                    if (data[i].indexOf(61) > -1) {
                        String[] vs = ConstraintValueEditorHelper.splitValue((String)data[i]);
                        realValue = vs[0];
                        display = vs[1];
                    }
                    if (this.varName.equals(realValue)) {
                        selected = i;
                    }
                    list.add(display);
                    String key = DSLSentenceWidget.ITEM_ + list.getItemCount();
                    list.setData(key, (Object)realValue);
                    ++i;
                }
                if (selected >= 0) {
                    list.select(selected);
                }
            }
            list.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DSLSentenceWidget.this.updateSentence();
                    DSLSentenceWidget.this.getModeller().setDirty(true);
                }
            });
            this.resultWidget = list;
            comp.layout();
        }

        public Control getControl() {
            return this.resultWidget;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFactAndField() {
            return this.factAndField;
        }

        public void setFactAndField(String factAndField) {
            this.factAndField = factAndField;
        }
    }

    class FieldEditor
    implements ModelWidget {
        private Text control;
        private String oldValue = "";
        private String regex = "";

        public FieldEditor(Composite parent) {
            this.control = DSLSentenceWidget.this.toolkit.createText(parent, "");
            this.control.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text otherBox = FieldEditor.this.control;
                    if (!FieldEditor.this.regex.equals("") && !otherBox.getText().matches(FieldEditor.this.regex)) {
                        System.err.println("VALUE IS NOT VALID: " + otherBox.getText());
                        FieldEditor.this.control.setText(FieldEditor.this.oldValue);
                    } else {
                        FieldEditor.this.oldValue = otherBox.getText();
                        DSLSentenceWidget.this.updateSentence();
                        DSLSentenceWidget.this.getModeller().setDirty(true);
                    }
                }
            });
        }

        public void setText(String t) {
            this.control.setText(t);
        }

        public void setVisibleLength(int l) {
        }

        public Control getControl() {
            return this.control;
        }

        public String getText() {
            return this.control.getText();
        }

        public void setRestriction(String regex) {
            this.regex = regex;
        }

        public String getRestriction() {
            return this.regex;
        }

        public boolean isValid() {
            boolean result = true;
            if (!this.regex.equals("")) {
                result = this.control.getText().matches(this.regex);
            }
            return result;
        }
    }

    class LabelWidget
    implements ModelWidget {
        private Label control;
        private String val;

        public LabelWidget(Composite parent, String text) {
            this.val = text;
            this.control = DSLSentenceWidget.this.toolkit.createLabel(parent, text);
        }

        public Control getControl() {
            return this.control;
        }

        public String getText() {
            return this.val;
        }
    }

    class NewLine
    implements ModelWidget {
        private Composite control;

        public NewLine(Composite parent) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(parent);
        }

        public Control getControl() {
            return this.control;
        }
    }
}

