/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.bpmn2.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.WorkItemDefinitions;
import org.drools.eclipse.flow.common.editor.GenericModelEditor;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowProcessWrapper;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowWrapperBuilder;
import org.drools.eclipse.flow.ruleflow.core.StartNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.drools.eclipse.flow.ruleflow.editor.RuleFlowPaletteFactory;
import org.drools.eclipse.flow.ruleflow.editor.editpart.RuleFlowEditPartFactory;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkDefinitionExtension;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.TimerNode;

public class BPMNModelEditor
extends GenericModelEditor {
    protected EditPartFactory createEditPartFactory() {
        RuleFlowEditPartFactory factory = new RuleFlowEditPartFactory();
        factory.setProject(this.getJavaProject());
        return factory;
    }

    protected PaletteRoot createPalette() {
        return RuleFlowPaletteFactory.createPalette();
    }

    protected Object createModel() {
        RuleFlowProcessWrapper result = new RuleFlowProcessWrapper();
        StartNodeWrapper start = new StartNodeWrapper();
        start.setConstraint(new Rectangle(100, 100, -1, -1));
        result.addElement(start);
        start.setParent(result);
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        String name = file.getName();
        result.setName(name.substring(0, name.length() - 3));
        return result;
    }

    public RuleFlowProcessWrapper getRuleFlowModel() {
        return (RuleFlowProcessWrapper)this.getModel();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IFileEditorInput) {
            this.refreshPalette(((IFileEditorInput)input).getFile());
        }
    }

    private void refreshPalette(IFile file) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            try {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(javaProject);
                try {
                    Thread.currentThread().setContextClassLoader(newLoader);
                    PaletteDrawer drawer = (PaletteDrawer)this.getPaletteRoot().getChildren().get(2);
                    ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
                    try {
                        for (final WorkDefinition workDefinition : WorkItemDefinitions.getWorkDefinitions((IResource)file).values()) {
                            String label;
                            String description = workDefinition.getName();
                            String icon = null;
                            if (workDefinition instanceof WorkDefinitionExtension) {
                                WorkDefinitionExtension extension = (WorkDefinitionExtension)workDefinition;
                                label = extension.getDisplayName();
                                description = extension.getExplanationText();
                                icon = extension.getIcon();
                            } else {
                                label = workDefinition.getName();
                            }
                            URL iconUrl = null;
                            if (icon != null) {
                                iconUrl = newLoader.getResource(icon);
                            }
                            if (iconUrl == null) {
                                iconUrl = DroolsEclipsePlugin.getDefault().getBundle().getEntry("icons/action.gif");
                            }
                            CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(label, description, WorkItemWrapper.class, (CreationFactory)new SimpleFactory(WorkItemWrapper.class){

                                public Object getNewObject() {
                                    WorkItemWrapper workItemWrapper = (WorkItemWrapper)super.getNewObject();
                                    workItemWrapper.setName(label);
                                    workItemWrapper.setWorkDefinition(workDefinition);
                                    return workItemWrapper;
                                }
                            }, ImageDescriptor.createFromURL((URL)iconUrl), ImageDescriptor.createFromURL((URL)iconUrl));
                            entries.add(combined);
                        }
                    }
                    catch (Throwable t) {
                        DroolsEclipsePlugin.log(t);
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Parsing work item definitions", (String)t.getMessage());
                    }
                    drawer.setChildren(entries);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            catch (Exception e) {
                DroolsEclipsePlugin.log(e);
            }
        }
    }

    protected void writeModel(OutputStream os) throws IOException {
        this.writeModel(os, true);
    }

    protected void writeModel(OutputStream os, boolean includeGraphics) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        try {
            RuleFlowProcess process = this.getRuleFlowModel().getRuleFlowProcess();
            XmlBPMNProcessDumper dumper = XmlBPMNProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process, 2);
            writer.write(out);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
            Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, "Could not save BPMN process, see error log for more details and contact the developers: " + t.getMessage(), t);
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Process Save Error", (String)"Unable to save process.", (IStatus)status);
            throw new IOException(t.getMessage());
        }
        writer.close();
    }

    protected void createModel(InputStream is) {
        try {
            InputStreamReader isr = new InputStreamReader(is);
            SemanticModules semanticModules = new SemanticModules();
            semanticModules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            semanticModules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
            semanticModules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(semanticModules);
            try {
                List processes = xmlReader.read((Reader)isr);
                if (processes == null || processes.size() == 0) {
                    this.setModel(this.createModel());
                } else {
                    RuleFlowProcess process = (RuleFlowProcess)processes.get(0);
                    if (process == null) {
                        this.setModel(this.createModel());
                    } else {
                        this.correctEventNodeSize(process.getNodes());
                        this.setModel(new RuleFlowWrapperBuilder().getProcessWrapper((Process)process, this.getJavaProject()));
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Could not read RuleFlow file", (String)("An exception occurred while reading in the RuleFlow XML: " + t.getMessage() + " See the error log for more details."));
                this.setModel(this.createModel());
            }
            isr.close();
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }

    private void correctEventNodeSize(Node[] nodes) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer y;
            Integer x;
            Integer height;
            Integer width;
            Node node = nodeArray[n2];
            if (node instanceof StartNode || node instanceof EndNode || node instanceof EventNode || node instanceof FaultNode || node instanceof TimerNode) {
                width = (Integer)node.getMetaData().get("width");
                if (width == null) {
                    width = 48;
                }
                if ((height = (Integer)node.getMetaData().get("height")) == null) {
                    height = 48;
                }
                if (width != 48 || height != 48) {
                    node.getMetaData().put("width", 48);
                    node.getMetaData().put("height", 48);
                    x = (Integer)node.getMetaData().get("x");
                    y = (Integer)node.getMetaData().get("y");
                    x = x - (48 - width) / 2;
                    y = y - (48 - height) / 2;
                    node.getMetaData().put("x", x);
                    node.getMetaData().put("y", y);
                }
            } else if (node instanceof Split || node instanceof Join) {
                width = (Integer)node.getMetaData().get("width");
                if (width == null) {
                    width = 49;
                }
                if ((height = (Integer)node.getMetaData().get("height")) == null) {
                    height = 49;
                }
                if (width != 49 || height != 49) {
                    node.getMetaData().put("width", 49);
                    node.getMetaData().put("height", 49);
                    x = (Integer)node.getMetaData().get("x");
                    y = (Integer)node.getMetaData().get("y");
                    x = x - (49 - width) / 2;
                    y = y - (49 - height) / 2;
                    node.getMetaData().put("x", x);
                    node.getMetaData().put("y", y);
                }
            } else if (node instanceof CompositeNode) {
                this.correctEventNodeSize(((CompositeNode)node).getNodes());
            }
            ++n2;
        }
    }
}

