/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.ArrayList;
import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddCompositeConstraintOptionDialog;
import org.drools.eclipse.rulebuilder.ui.AddNewFieldConstraintDialog;
import org.drools.eclipse.rulebuilder.ui.AssignFieldVariableDialog;
import org.drools.eclipse.rulebuilder.ui.ConstraintValueEditor;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class FactPatternWidget
extends Widget {
    private final CompositeFactPattern parentPattern;
    private final FactPattern pattern;
    private boolean bindable;

    public FactPatternWidget(FormToolkit toolkit, Composite parent, RuleModeller mod, FactPattern factPattern, CompositeFactPattern parentPattern, int idx, boolean canBind) {
        super(parent, toolkit, mod, idx);
        this.pattern = factPattern;
        this.parentPattern = parentPattern;
        this.bindable = canBind;
        GridLayout l = new GridLayout();
        l.numColumns = 4;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        l.verticalSpacing = 0;
        parent.setLayout((Layout)l);
        this.create();
    }

    private void create() {
        Composite composite = new Composite(this.parent, 524288);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label l = this.toolkit.createLabel(composite, this.getPatternLabel());
        l.setBackground(Display.getDefault().getSystemColor(15));
        GridData labelGD = new GridData(1808);
        labelGD.horizontalSpan = 2;
        labelGD.verticalAlignment = 0x1000000;
        composite.setLayoutData((Object)labelGD);
        composite.setBackground(Display.getDefault().getSystemColor(15));
        this.addDeleteAction();
        this.addMoreOptionsAction();
        Composite constraintComposite = this.toolkit.createComposite(this.parent);
        GridLayout constraintLayout = new GridLayout();
        constraintLayout.numColumns = 8;
        constraintLayout.marginLeft = 5;
        constraintComposite.setLayout((Layout)constraintLayout);
        int row = 0;
        while (row < this.pattern.getFieldConstraints().length) {
            FieldConstraint constraint = this.pattern.getFieldConstraints()[row];
            if (constraint instanceof SingleFieldConstraint) {
                boolean bl = ((SingleFieldConstraint)constraint).getParent() != null;
            }
            this.renderFieldConstraints(constraintComposite, constraint, null, row, true, false);
            ++row;
        }
        this.toolkit.paintBordersFor(constraintComposite);
    }

    private void addMoreOptionsAction() {
        ImageHyperlink link = this.addImage(this.parent, "icons/new_item.gif");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                AddNewFieldConstraintDialog popup = new AddNewFieldConstraintDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.toolkit, FactPatternWidget.this.getModeller(), FactPatternWidget.this.pattern, FactPatternWidget.this.parentPattern != null);
                popup.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setToolTipText("Add a field to this condition, or bind a varible to this fact.");
    }

    private void addDeleteAction() {
        ImageHyperlink delWholeLink = this.addImage(this.parent, "icons/delete_obj.gif");
        delWholeLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this ENTIRE condition, and all the field constraints that belong to it.");
                dialog.setText("Remove this entire condition?");
                if (dialog.open() == 64) {
                    if (FactPatternWidget.this.parentPattern == null) {
                        if (FactPatternWidget.this.getModeller().getModel().removeLhsItem(FactPatternWidget.this.index)) {
                            FactPatternWidget.this.getModeller().reloadLhs();
                        } else {
                            FactPatternWidget.this.showMessage("Can't remove that item as it is used in the action part of the rule.");
                        }
                    } else {
                        FactPatternWidget.this.deleteBindedFact();
                    }
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delWholeLink.setToolTipText("Remove this condition.");
    }

    private void renderFieldConstraints(Composite constraintComposite, FieldConstraint constraint, CompositeFieldConstraint parentConstraint, int row, boolean showBinding, boolean nested) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(constraintComposite, row, constraint, parentConstraint, showBinding, nested);
        } else if (constraint instanceof CompositeFieldConstraint) {
            this.compositeFieldConstraintEditor(constraintComposite, (CompositeFieldConstraint)constraint, parentConstraint, row, nested);
        }
    }

    private void compositeFieldConstraintEditor(Composite constraintComposite, final CompositeFieldConstraint constraint, CompositeFieldConstraint parentConstraint, int row, boolean nested) {
        if (constraint.compositeJunctionType.equals("&&")) {
            this.toolkit.createLabel(constraintComposite, "All of:");
        } else {
            this.toolkit.createLabel(constraintComposite, "Any of:");
        }
        this.addRemoveButton(constraintComposite, parentConstraint, row, "icons/delete_obj.gif", nested);
        ImageHyperlink link = this.addImage(constraintComposite, "icons/new_item.gif");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                AddCompositeConstraintOptionDialog popup = new AddCompositeConstraintOptionDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.getModeller(), constraint, FactPatternWidget.this.pattern);
                popup.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setToolTipText("Add fields to this constriant.");
        this.addNestedElements(constraintComposite, constraint);
    }

    private void addNestedElements(Composite constraintComposite, CompositeFieldConstraint constraint) {
        FieldConstraint[] nestedConstraints = constraint.constraints;
        if (nestedConstraints != null) {
            Composite nestedComposite = this.toolkit.createComposite(constraintComposite);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            nestedComposite.setLayoutData((Object)gd);
            GridLayout l = new GridLayout();
            l.numColumns = 8;
            l.marginBottom = 0;
            l.marginHeight = 0;
            l.marginLeft = 0;
            l.marginRight = 0;
            l.marginTop = 0;
            l.marginWidth = 0;
            l.verticalSpacing = 0;
            nestedComposite.setLayout((Layout)l);
            int i = 0;
            while (i < nestedConstraints.length) {
                this.renderFieldConstraints(nestedComposite, nestedConstraints[i], constraint, i, false, true);
                this.toolkit.paintBordersFor(nestedComposite);
                ++i;
            }
        } else {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            Label dummyLabel = this.toolkit.createLabel(constraintComposite, "");
            dummyLabel.setLayoutData((Object)gd);
        }
    }

    private void renderSingleFieldConstraint(Composite constraintComposite, int row, FieldConstraint constraint, CompositeFieldConstraint parentConstraint, boolean showBinding, boolean nested) {
        SingleFieldConstraint c = (SingleFieldConstraint)constraint;
        if (c.getConstraintValueType() != 5) {
            this.createConstraintRow(constraintComposite, parentConstraint, row, c, showBinding, nested);
        } else {
            this.createPredicateConstraintRow(constraintComposite, row, c);
        }
    }

    private void createConstraintRow(Composite constraintComposite, CompositeFieldConstraint parentConstraint, int row, SingleFieldConstraint c, boolean showBinding, boolean nested) {
        Composite pad = new Composite(constraintComposite, 0);
        pad.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        pad.setLayoutData((Object)gd);
        GridData data = new GridData();
        data.horizontalIndent = 15 * this.getNests(c);
        this.addBindingField(pad, c, showBinding, data);
        this.toolkit.createLabel(pad, c.getFieldName());
        if (!(this.hasChildren(row) || c.connectives != null && c.connectives.length != 0)) {
            this.addRemoveButton(constraintComposite, parentConstraint, row, "icons/delete_item_small.gif", nested);
        } else {
            this.toolkit.createLabel(constraintComposite, "");
        }
        this.operatorDropDown(constraintComposite, c);
        this.constraintValueEditor(constraintComposite, (BaseSingleFieldConstraint)c, c.getFieldName());
        this.createConnectives(constraintComposite, c);
        this.addConnectiveAction(constraintComposite, c);
    }

    private int getNests(SingleFieldConstraint c) {
        SingleFieldConstraint s = (SingleFieldConstraint)c.getParent();
        int nests = 0;
        while (s != null) {
            ++nests;
            s = (SingleFieldConstraint)s.getParent();
        }
        return nests;
    }

    private void addBindingField(Composite constraintComposite, final SingleFieldConstraint c, boolean showBinding, Object data) {
        if (!c.isBound()) {
            if (this.bindable && showBinding) {
                ImageHyperlink link = this.addImage(constraintComposite, "icons/new_item.gif");
                link.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        AssignFieldVariableDialog popup = new AssignFieldVariableDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.toolkit, FactPatternWidget.this.getModeller(), c, FactPatternWidget.this.pattern);
                        popup.open();
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
                link.setToolTipText("Bind the field called [" + c.getFieldName() + "] to a variable.");
                link.setLayoutData(data);
            } else {
                this.toolkit.createLabel(constraintComposite, "");
            }
        } else {
            this.toolkit.createLabel(constraintComposite, "[" + c.getFieldBinding() + "]");
        }
    }

    private void createPredicateConstraintRow(Composite constraintComposite, int row, SingleFieldConstraint c) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 6;
        this.addImage(constraintComposite, "icons/function_assets.gif");
        this.formulaValueEditor(constraintComposite, (BaseSingleFieldConstraint)c, gd);
        this.addRemoveButton(constraintComposite, null, row, "icons/delete_item_small.gif", false);
    }

    private void createConnectives(Composite parent, SingleFieldConstraint c) {
        if (c.connectives != null && c.connectives.length > 0) {
            int i = 0;
            while (i < c.connectives.length) {
                this.toolkit.createLabel(parent, "");
                this.toolkit.createLabel(parent, "");
                this.toolkit.createLabel(parent, "");
                ConnectiveConstraint con = c.connectives[i];
                this.addRemoveConstraintAction(parent, c, con);
                this.connectiveOperatorDropDown(parent, con, c.getFieldName());
                this.constraintValueEditor(parent, (BaseSingleFieldConstraint)con, c.getFieldName());
                ++i;
            }
        }
    }

    private void constraintValueEditor(Composite parent, BaseSingleFieldConstraint c, String name) {
        String type = this.modeller.getSuggestionCompletionEngine().getFieldType(this.pattern.getFactType(), name);
        new ConstraintValueEditor(parent, c, this.toolkit, this.modeller, type, this.pattern);
    }

    private void addConnectiveAction(Composite constraintComposite, final SingleFieldConstraint c) {
        ImageHyperlink link = this.addImage(constraintComposite, "icons/add_connective.gif");
        link.setToolTipText("Add more options to this fields values.");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                c.addNewConnective();
                FactPatternWidget.this.getModeller().reloadLhs();
                FactPatternWidget.this.getModeller().setDirty(true);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setLayoutData((Object)new GridData(800));
    }

    private void addRemoveButton(Composite constraintComposite, CompositeFieldConstraint parentConstraint, int row, String iconRef, boolean nested) {
        if (nested) {
            this.addNestedConstraintDeleteAction(constraintComposite, parentConstraint, row, iconRef);
        } else {
            this.addRemoveFieldAction(constraintComposite, row, iconRef);
        }
    }

    private void addNestedConstraintDeleteAction(Composite constraintComposite, final CompositeFieldConstraint parentConstraint, final int row, String iconRef) {
        ImageHyperlink delLink = this.addImage(constraintComposite, iconRef);
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this (nested) restriction.");
                dialog.setText("Remove this item from nested constraint?");
                if (dialog.open() == 64) {
                    parentConstraint.removeConstraint(row);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void addRemoveFieldAction(Composite constraintComposite, final int currentRow, String iconRef) {
        ImageHyperlink delLink = this.addImage(constraintComposite, iconRef);
        delLink.setToolTipText("Remove this fieldconstraint");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this item?");
                dialog.setText("Remove this item?");
                if (dialog.open() == 64) {
                    FactPatternWidget.this.pattern.removeConstraint(currentRow);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delLink.setLayoutData((Object)new GridData(800));
    }

    private boolean hasChildren(int row) {
        SingleFieldConstraint con = (SingleFieldConstraint)this.pattern.getFieldConstraints()[row];
        FieldConstraint[] fc = this.pattern.getFieldConstraints();
        int i = row;
        while (i < fc.length) {
            SingleFieldConstraint f = (SingleFieldConstraint)fc[i];
            if (con.equals(f.getParent())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addRemoveConstraintAction(Composite composite, final SingleFieldConstraint constraint, final ConnectiveConstraint connConstraint) {
        ImageHyperlink delLink = this.addImage(composite, "icons/delete_item_small.gif");
        delLink.setToolTipText("Remove this field constraint");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this item?");
                dialog.setText("Remove this item?");
                if (dialog.open() == 64) {
                    ConnectiveConstraint[] connectives = constraint.connectives;
                    ArrayList<ConnectiveConstraint> nConnectives = new ArrayList<ConnectiveConstraint>();
                    int i = 0;
                    while (i < connectives.length) {
                        if (connectives[i] != connConstraint) {
                            nConnectives.add(connectives[i]);
                        }
                        ++i;
                    }
                    constraint.connectives = nConnectives.toArray(new ConnectiveConstraint[nConnectives.size()]);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        delLink.setLayoutData((Object)new GridData(896));
    }

    private String getPatternLabel() {
        if (this.pattern.getBoundName() != null) {
            return String.valueOf(this.pattern.getFactType()) + " [" + this.pattern.getBoundName() + "]";
        }
        return this.pattern.getFactType();
    }

    private void operatorDropDown(Composite parent, final SingleFieldConstraint c) {
        String[] ops = this.getCompletions().getOperatorCompletions(this.pattern.getFactType(), c.getFieldName());
        final Combo box = new Combo(parent, 76);
        int i = 0;
        while (i < ops.length) {
            String op = ops[i];
            box.add(HumanReadable.getOperatorDisplayName(op));
            if (op.equals(c.getOperator())) {
                box.select(i);
            }
            ++i;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        box.setLayoutData((Object)gridData);
        box.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                c.setOperator(HumanReadable.getOperatorName(box.getText()));
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void connectiveOperatorDropDown(Composite parent, final ConnectiveConstraint con, String fieldName) {
        String[] ops = this.getCompletions().getConnectiveOperatorCompletions(this.pattern.getFactType(), fieldName);
        final Combo box = new Combo(parent, 76);
        int i = 0;
        while (i < ops.length) {
            String op = ops[i];
            box.add(HumanReadable.getOperatorDisplayName(op));
            if (op.equals(con.operator)) {
                box.select(i);
            }
            ++i;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        box.setLayoutData((Object)gridData);
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                con.operator = HumanReadable.getOperatorName(box.getText());
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void formulaValueEditor(Composite parent, final BaseSingleFieldConstraint c, GridData gd) {
        final Text box = this.toolkit.createText(parent, "");
        if (c.getValue() != null) {
            box.setText(c.getValue());
        }
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        box.setLayoutData((Object)gd);
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                c.setValue(box.getText());
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void deleteBindedFact() {
        ArrayList<IFactPattern> newPatterns = new ArrayList<IFactPattern>();
        int i = 0;
        while (i < this.parentPattern.getPatterns().length) {
            if (this.parentPattern.getPatterns()[i] != this.pattern) {
                newPatterns.add(this.parentPattern.getPatterns()[i]);
            }
            ++i;
        }
        this.parentPattern.clearFactPatterns();
        this.parentPattern.addFactPatterns((IFactPattern[])newPatterns.toArray(new FactPattern[newPatterns.size()]));
        this.getModeller().reloadLhs();
    }

    private SuggestionCompletionEngine getCompletions() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

